<?php
/*	Esprit Badge Info
	Stephanie Mitchell, 15 September, 2013
	It returns an array with a CSS class code ("stop", "go" etc.) and an HTML string to be
	displayed.
	This function can be used to quickly verify that a badge is properly coded.
*/
function maincheckin($id, $heading = '') {

	$testing = false;
	$init = false;
	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
	require_once ".config.php";
	require_once "mysql_utilities.php";
	
	if (isset($_REQUEST['mode'])) {
		$testing = ($_REQUEST['mode'] == 'test');
		$init = ($_REQUEST['mode'] == 'init');
	}
	$cookie = $_COOKIE['espritbadgereader'];
	$error_string = "<h2>Scan Error</h2><h1>Please rescan</h1>";

	if (!$cookie) {
		return ['type' => 'stop',
			'content' => "$error_string<h3 class=\"message\">Unassigned function.</h3>"];
	}
	$id = (isset($_REQUEST['id']) ? $_REQUEST['id'] : false);
	
	if ($init) {
		return ['type' => 'wait',
			'content' => "<h1>Initialising. Please wait. Your scanner will start shortly.</h1>"];
	} elseif (!$id) {
		return ['type' => 'stop',
			'content' => "$error_string<h3 class=\"message\">Missing ID number.</h3>"];
	}
	/*	Get participant info */
	
	require_once ".regconnect.php";
	global $db;
	$db = get_regconnect('Normal');
	$GLOBALS['dbConnect'] = mysqli_connect($db['hn'], $db['un'], $db['pw'], $db['db']) or show_error(__FUNCTION__ . ": Couldn't connect to database server: " . mysqli_error($GLOBALS['dbConnect']));

	$sql = "SELECT firstnamepref, lastnamepref, confirmation_no, reg_status
		FROM reg
		WHERE concat('{$GLOBALS['esprit_yy']}', badge_code)='$id'";
// 	print 'Final SQL query: '.$sql;
	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or show_error('Database error on participant status query: '.mysqli_error($GLOBALS['dbConnect']).'; query='.$sql);
	$row = mysqli_fetch_assoc($result);
	$message = '';	//	Check status for eligibility
	if (!$row) {
		$badge_eligible = false;	//	No record of this badge
	} else {
		$badge_eligible = true;	//	Assume it's good until proven otherwise
		extract($row);			//	REALLY quick and dirty
	}
	switch (true) {
	case (!$badge_eligible) :	//	No such badge (maybe scanning last year's
								//	or a stolen or lost one
		$message = 'No record of this badge.';
		$bg = 'stop';
		$process = false;
		break;

	case ($badge_eligible) :
		$message = 'Badge exists and is on file.';
		$bg = 'go';
		$process = false;
		break;
	}

	/*	Now generate badge display. */

	$bg = isset($bg) ? $bg : 'unset';	//	Did we set a background in all this?
	switch ($bg) {						//	Create status message to match it
	case ('go') : $status_msg = 'GO'; break;
	case ('stop') : $status_msg = 'STOP'; break;
	case ('wait') : $status_msg = 'ALERT'; break;
	case ('alert') : $status_msg = 'ALERT'; break;
	case ('unset') : $status_msg = '???'; break;
	}

	$message = !isset($message) ? 'DISPLAY MESSAGE NOT SET!' : "<h1 class=\"message\">$status_msg</h1><h3 class=\"message\">$message</h3>";

	$display_string = <<<BODY
	<h2>$heading</h2>
	<h1>$firstnamepref $lastnamepref</h1>
	</tr>
	<h3>Confirmation: $confirmation_no</h3>

BODY;
	return ['type' => $bg,
				'content' => "$display_string $message"];
}
?>
