<?php
/*	Esprit online registration Badge reader system.
	Stephanie Mitchell
	21 September, 2013
	Main dispatch for badge reader functions.
	Overall flow:
	Participant badges contain a URL encoded in a QR code of the form
		https://badge.espritgala.org/?id=<badge_code>
	This file, /esprit/badge/index.php, is the destination of that URL.
	The idea is that the QR code is scanned by a mobile device such as a smartphone which
	then send the phone's browser here.
	
	What happens next depends on the contents of two cookies set on the phone. That makes
	it possible to use the phone scanner to do different things depending on the cookies.
	
	The cookies are:
		espritbadgereader[class]		Determines the class of user and therefore what
										functions she can perform. Set when a valid badge
										is scanned. Validity is determined as described
										below.
		espritbadgereader[function]		Determines the function for which the app is set.
										The user selects this from a menu either after
										first scanning her badge or upon clicking
										Change Function.
	
	If there's no class cookie, scanning a valid badge will set one (effectively "logging
	in" the badge) and ask the user to select a function.
	A valid badge is determined as follows:
		-	the ID is looked up in the registration database and the correponding email is
			retrieved.
		-	the email address is looked up in the regcontrol table to see if there's a
			record with the category "Badge_Control,<classname>". If so, the badge is
			valid and the class cookie is set to <classname>.
			Badges that don't pass both tests simply report "This is badge number
			<number>."
	
	Once the class and function cookies are set, the phone no longer performs the above
	checks. It then simply scans badges and performs the function indicated.
	
	The net effect is that the smartphone becomes a handheld checkin scanner for any of a
	variety of functions.
	
	Most scanning apps will work, including the QR scanners built into most smartphone
	cameras. Many require an extra tap on the screen to actually open the URL, so hunt
	around for one that will immediately go to the URL; it makes the whole scanning
	operation go MUCH faster.
	
*/
/*	Error reporting setup */

/*
	Check that w're being called via HTTPS
*/
if (isset($_SERVER['HTTPS']) &&
    ($_SERVER['HTTPS'] == 'on' || $_SERVER['HTTPS'] == 1) ||
    isset($_SERVER['HTTP_X_FORWARDED_PROTO']) &&
    $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https') {
  $protocol = 'https://';
}
else {
  $protocol = 'http://';	//	Invalid; we only accept https badges
}


define('SOUNDS_FOLDER', 'siri');	//	"voice" or "redalert" or "siri", case-sensitive
									//	See sounds/speechlists.php for details.
define('SHOW_CHANGE', true);
define('HIDE_CHANGE', false);
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once ".config.php";
require_once 'badgeutils.php';
//	ini_set('display_startup_errors',1);
//	ini_set('display_errors', 1);
//	error_reporting(-1);

if ($protocol != 'https://') {
	print_screen('stop', "Badge is invalid. Protocol error ($protocol)", false);
	exit;
}
	/*
		This app is only meant for use with certain devices. The device must return a 
		$_SERVER['HTTP_USER_AGENT'] containing one of the provided strings. If TESTING is
		set in .config.php, any device will work.
	*/
define('QUADODO_IN_SYSTEM', 1);	//	Magic constant required for .config.php to
								//	load, not used in this app.
global $authorised_devices;
$authorised_devices = ['Mobile', 'Android', 'Firefox'];

$testing = false;
$init = false;

if (isset($_REQUEST['mode'])) {
	$testing = ($_REQUEST['mode'] == 'test');
	$init = ($_REQUEST['mode'] == 'init');
}
if (!validate_device($testing)) {
	print_screen('stop', "<h3 class=\"message\">This can only be used from a mobile device.</h3>", false);
	exit;
}

$id = (isset($_REQUEST['id']) ? $_REQUEST['id'] : false);

if (!isset($_COOKIE['espritbadgereader']['class'])) {	//	If no cookie, then login and
														//	set one
	$temp_class = autologin($id);	//	Need $temp_class as cookie isn't yet set
	if (!$temp_class) {
		print_screen('wait', "$id", HIDE_CHANGE);
		exit;
	}
}
$t = isset($_COOKIE['espritbadgereader']['class']) ?
		$_COOKIE['espritbadgereader']['class'] :
	(isset($temp_class) ?
		$temp_class :
	false);
// 	print 'Existing cookies are:';
// 	print_r($_COOKIE);print '<br />'; print "; \$temp_class=$temp_class";
if (!isset($_COOKIE['espritbadgereader']['function'])) {	//	If no function set then ask for one
// print __FILE__ .'/' . __LINE__ . ': no function cookie set';
// exit;
	header("Location: /setfunction.php?pending_class_cookie=$t");
	exit;
}
$live = !$testing;
$f = explode(':',urldecode($_COOKIE['espritbadgereader']['function']));

$f_dest = $f[0];		//	Function destination
$f_id = $f[1];			//	ID parameter
$f_timeout = $f[2];		//	timeout parameter
$f_title = $f[3];		//	title parameter
switch ($f_dest) {
	/*	Checkins for meals */
case 'meal':
	include 'mealcheckin.php';
	$r = mealcheckin($id, $f_id, $f_title);
	break;

case 'mealr':
	include 'mealreset.php';
	$r = mealreset($id, $f_id, $f_title);
	break;

case 'eventcheckin':
	include 'eventcheckin.php';
	$r = eventcheckin($id, $f_id, $f_title);
	break;

case 'deskcheckin':
	include 'maincheckin.php';
	$r = maincheckin($id, 'Desk Checkin');
	break;

case 'ybphotocheckin':
	include 'ybphotocheckin.php';
	$r = ybphotocheckin($id, 'YB Photo Checkin');
	break;

case 'badgecheck':
	include 'badgecheck.php';
	$r = maincheckin($id, 'Badge Diagnose');
	break;

// case 'manage':					//	Badge Manage not supported
// //	include 'badgeutils.php';
// 	$r = manage($id, 'Manage Badge Access');
// 	break;

case 'diagnose':
//	include 'badgeutils.php';	//	Diagnose code is in badgeutils.php,
								//	already included
	$r = badge_diagnose($id);
	break;

case 'logout':
//	include 'badgeutils.php';	//	Logout code is in badgeutils.php,
								//	already included
	$r = logout($id, 'logout');
	break;

default:
	$r['type'] = 'stop';
	$r['content'] = '<body>
<h2>No valid function set. Please <a href="setfunction.php">select a function</a>.</h2>
</body>';
}

print_screen($r['type'], $r['content'], SHOW_CHANGE);
?>
