<?php
/*	Esprit online registration Badge reader system.
	Stephanie Mitchell
	21 September, 2013
	Set function for badge reader functions.
	Overall flow:
	Check to see if we're returning from a form submission. If so, set the
	cookie and exit. Otherwise, display the form, which calls us again with a
	method="post".
*/

/*	Set timezone. In most of the rest of the reg system this is set in
	.config.php, but that isn't called here in the interests of efficiency. We
	need to set for local time for the date-based selection of events.
*/

ini_set('date.timezone', 'America/Los_Angeles');

if ($_REQUEST['function']) {
	$c_l = $_REQUEST['function'];
	$c = explode(':', $c_l);	//	Extract timeout value
	setcookie('espritbadgereader[function]', $c_l, time()+$c[2]);
	header('Location: index.php');
} else {
// print "\$pending_class_cookie from REQUEST='{$_REQUEST['pending_class_cookie']}'<br />";
// $k = $_COOKIE['espritbadgereader']['class');
// print "\$_COOKIE['espritbadgereader']['class'] from COOKIE='$k'";

	if (!isset($_COOKIE['espritbadgereader']['class'])
		and !isset($_REQUEST['pending_class_cookie'])) {
		print 'Trying to set function but no user class given. ';
		exit;
	} else {
		$auth = isset($_COOKIE['espritbadgereader']['class']) ? $_COOKIE['espritbadgereader']['class'] : (isset($_REQUEST['pending_class_cookie']) ? $_REQUEST['pending_class_cookie'] : false);

		/*	Create array for function menu. Timeout is in seconds. Auth is
			comma-separated list of user groups who can perform this function.
			Menu contains only items for the current day.
		*/
		$now = date('D');		//	Sun, Mon etc.
//		die("\$now=$now");
		switch ($now) {
		case 'Mon':
		case 'Tue':
		case 'Wed':
		case 'Thu':
		case 'Fri':
			$options['Checkin Fri Breakf.'] = ['dest' => 'meal', 'id' => 1,
				'timeout' => 1200, 'auth' => 'Admin, Door, Meals'];
			$options['Checkin Fri Lunch'] = ['dest' => 'meal', 'id' => 2,
				'timeout' => 3600, 'auth' => 'Admin, Door, Meals'];
			$options['Checkin Fri Dinner'] = ['dest' => 'meal', 'id' => 3,
				'timeout' => 3600, 'auth' => 'Admin, Door, Meals'];
			$options['Reset Fri Breakf.'] = ['dest' => 'mealr', 'id' => 1,
				'timeout' => 120, 'auth' => 'Admin'];
			$options['Reset Fri Lunch'] = ['dest' => 'mealr', 'id' => 2,
				'timeout' => 120, 'auth' => 'Admin'];
			$options['Reset Fri Dinner'] = ['dest' => 'mealr', 'id' => 3,
				'timeout' => 120, 'auth' => 'Admin'];
			break;
		case 'Sat':
			$options['Checkin Sat Lunch'] = ['dest' => 'meal', 'id' => 4,
				'timeout' => 3600, 'auth' => 'Admin, Door, Meals'];
			$options['Checkin Sat Dinner'] = ['dest' => 'meal', 'id' => 5,
				'timeout' => 3600, 'auth' => 'Admin, Door, Meals'];
			$options['Reset Sat Lunch'] = ['dest' => 'mealr', 'id' => 4,
				'timeout' => 120, 'auth' => 'Admin'];
			$options['Reset Sat Dinner'] =['dest' => 'mealr', 'id' => 5,
				'timeout' => 120, 'auth' => 'Admin'];
			break;
		case 'Sun':
			$options['Checkin Sun Brunch'] = ['dest' => 'meal', 'id' => 6, 
				'timeout' => 3600, 'auth' => 'Admin, Door, Meals'];
			$options['Reset Sun Brunch'] = ['dest' => 'mealr', 'id' => 6,
				'timeout' => 120, 'auth' => 'Admin'];
		}
		$options['Desk Checkin'] = ['dest' => 'deskcheckin',
			'timeout' => 6000, 'auth' => 'Admin'];
		$options['Badge Diagnose'] = ['dest' => 'badgecheck',
			'timeout' => 6000, 'auth' => 'Admin'];
		$options['Diagnose'] = ['dest' => 'diagnose',
			'timeout' => 6000, 'auth' => 'Admin'];
// 		$options['Yearbook Photo'] = ['dest' => 'ybphotocheckin',
// 			'timeout' => 6000, 'auth' => 'Admin'];
		$options['Logout'] = ['dest' => 'logout', 'timeout' => 10,
			'auth' => '*'];	//	Appears on every login so you can logout even if
							//	there's been an error in your configuration
		
		/*
			Gather events for current weekday. 
		*/

		require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
		require_once ".config.php";
		require_once "mysql_utilities.php";
		require_once ".regconnect.php"; // hostname, ID and password
		$db = get_regconnect('Normal');
// die(__FILE__.':'.__LINE__);
// die('In ' . __FILE__ . ' at line ' . __LINE__);

		$GLOBALS['dbConnect'] = mysqli_connect($db['hn'], $db['un'], $db['pw'], $db['db']) or show_error(__FUNCTION__ . ": Couldn't connect to database server: " . mysqli_error($GLOBALS['dbConnect']));
		$sql = "SELECT bus_name, id, DAYNAME(resourcedate)
			FROM regpresenter
			WHERE DAYNAME(resourcedate)=dayname(CURRENT_DATE())
			AND resourcestatus='Scheduled'
			AND resourceformat NOT IN ('Service', 'External Event')";
		$result = mysqli_query($GLOBALS['dbConnect'], $sql) or show_error('Database error on event detail query: '.mysqli_error($GLOBALS['dbConnect']).'; query='.$sql);
		while ($row = mysqli_fetch_assoc($result)) {
			$options[$row['bus_name']] = [
				'dest' => 'eventcheckin',
				'id' => $row['id'],
				'timeout' => 7200,		//	2 hour timeout
				'auth' => 'Admin,Door'];
		}
		mysqli_close($GLOBALS['dbConnect']);
// 		print_r($options);
		?>
		<html>
		<link rel="stylesheet" href="styles.css" type="text/css">
		<head>
		</head>
		<body class="go">
		<?php print "<h3>This Badge is authorised:<br />class=$auth</h3>";
		?>
		<h3>Select a function and click Submit.</h3>
		<form name="setfunc" id="setfunc" action="setfunction.php" method="post">
		<p> Function:<br />
		<select name="function" id="function">
			<!-- format of value is cookiename:seconds of lifetime -->
			<option>-</option>
			<?php
			foreach ($options as $thiskey => $thisoption) {
				if (!(strpos($thisoption['auth'], $auth) === false) or $thisoption['auth'] == '*') {
					print "<option value=\"{$thisoption['dest']}:{$thisoption['id']}:{$thisoption['timeout']}:$thiskey\">$thiskey</option>";
				}
			}
			?>
		</select>
		<p></p><p></p>
		<input type="submit" id="submit" name="Submit" value="Submit" />
		</form>
		</body>
		</html>
		<?php 
	}
}?>