<?php
/*	Esprit Presenter and Vendor Display
	Stephanie Mitchell, 21 March, 2013
	This displays the bio pages for the current year's Esprit in a
	nice vertical-tab form. It uses jQuery and the Vertical Tabs plug-in for
	display. Data is gathered for each individual directly from the Esprit MySQL
	database, thus is it always current.
	
	Presenters appear in the list if they have an "Approved", "Scheduled", or
	"Cancelled" presentation. Vendors always appear in the list.
	
	Updated 20 January, 2013 to use iframes for MS Internet Explorer, which
	doesn't handle AJAX calls properly.
	
	Updated 21 March, 2013 to use jQuery menus for sub-menus to prevent the
	list from getting too long.

	Updated August 2016 to use Highslide windowing system instead of Fancybox, which appears to be no longer supported.
*/

$testing = (array_key_exists('mode', $_REQUEST) ? $_REQUEST['mode'] == 'test': false);
$standalone = true; //	($_REQUEST['view'] == 'standalone');

$live = !$testing;
define('QUADODO_IN_SYSTEM', true);
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once ".config.php";
require_once "functions.php";
if ($testing) { $test_msg = 'TEST';}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="X-UA-Compatible" content="IE=7" /> <!-- Fix for IE 8 shadowbox issues -->
<meta http-equiv="Pragma" content="no-cache" />
<meta http-equiv="Expires" content="-1" />
<meta name="viewport" content="width=device-width, initial-scale=1.0"/>
<title><?php print "Esprit $esprit_year Presenter and Vendor Bios $test_msg";?></title>
<!-- Include JQuery Core-->
<script type="text/javascript" src="/mgrlib/js/jquery.js"></script>
<script type="text/javascript" src="/mgrlib/js/jquery-ui.js"></script>

<!-- Highslide code -->

<script type="text/javascript" src="/js/highslide/highslide-full.js"></script>


<script type="text/javascript" src="/js/highslide/highslide-config.js"></script>


<link rel="stylesheet" type="text/css" href="/js/highslide/highslide.css">

<link rel="stylesheet" type="text/css" href="/css/styles.css">

<!-- jQuery menus -->
<style type="text/css">
.highslide-wrapper .highslide-html-content {
    width: auto;
    height: auto;
}
.highslide-thumbstrip-float li {
	height: auto;
	margin-bottom: 0.25em;
}
</style>
</head>

<body class="calendarpage">
<img src="../mgrimg/logo.gif" width="280" /><br />
<h2>Esprit <?php print $esprit_year;?> Presenters and Vendors</h2>
<?php print switchboard();?>
<p> Click headings and names below for details about our presenters and vendors and their offerings.
Click the X at the top right to close the information popup.</p>
<p><a href="../calendar/index.php">View Daily Schedule</a></p>
<?php
/*
	Create arrays of presenter and vendor names
*/

$online_esprit = (ONLINE_ESPRIT == true ? 'AND v.venue_type = "Online"' : 'AND v.venue_type != "Online"');

require_once ".regconnect.php"; // hostname, ID and password
require_once "mysql_utilities.php";
mysql_login('Read-only');
	$sql = "SELECT DISTINCT r.firstnamepref fname, r.lastnamepref lname,
			r.confirmation_no presenterid, r.is_presenter
		FROM reg r, regpresenter p
		INNER JOIN regvenues v ON v.venue_long=p.resourceroom
		WHERE r.confirmation_no=p.confirmation_no
			AND r.is_presenter='Yes'
			AND r.firstnamepref != 'Esprit Master'
			AND p.resourcestatus IN ('Approved', 'Scheduled')
			$online_esprit
		ORDER BY lname, fname";
	
//	print 'Final SQL query: '.$sql;

$resultpresenter = mysqli_query($GLOBALS['dbConnect'], $sql) or die('Database error on event query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);

	$sql = "SELECT DISTINCT r.firstnamepref fname, r.lastnamepref lname,
			r.confirmation_no vendorid, b.bus_name, bus_name,r.is_vendor
		FROM reg r, regvendor b
		INNER JOIN regvenues v ON v.venue_long=b.resourceroom
		WHERE r.confirmation_no=b.confirmation_no
			AND r.is_vendor='Yes'
			AND r.firstnamepref != 'Esprit Master'
			AND b.resourcestatus IN ('Approved', 'Scheduled')
			$online_esprit
		ORDER BY lname, fname";
	
//	print 'Final SQL query: '.$sql;
	
$resultvendor = mysqli_query($GLOBALS['dbConnect'], $sql) or die('Database error on event query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);
?>

<!-- begin menus section -->

<?php
print '<div id="presenters" style="width: 48%; float: left;">';

	/* 	Process presenters  */

	print "<li style=\"background-color:#FFDDFF; font-weight: bold;\"><a href=\"#\">Presenters</a>\n";
	
	$presenter_printed = false;
	$this_namegroup = '';
	print '<ul class="menu">';	//	Open the submenu even if there aren't any
	while ($mydata = mysqli_fetch_array($resultpresenter)) {
		print "<li><a href=\"presenterdetail.php?presenterid={$mydata['presenterid']}\" onclick=\"return hs.htmlExpand(this, { objectType: 'iframe', slideshowGroup: 'Presenter' } )\">{$mydata['fname']} {$mydata['lname']} </a></li>\n";
		$presenter_printed = true;
	}

	if (!$presenter_printed) {	//	Did we get any presenters?
		print '<li class="ui-state-disabled">No presenters</li></ul>';	//	No
	} else {
// 		print '</li></ul>';			//	Close namegroup submenu off
		print '</li></ul>';			//	Close presenter list menu off
	}
	print "</div>";	//	Close presenter div

	/* 	Process Vendors  */

print '<div id="vendors" style="width: 48%; float: right;">';

	print "<li style=\"background-color:#FFDDFF; font-weight: bold;\"><a href=\"#\">Vendors</a>\n";
	
	$vendor_printed = false;
	$this_namegroup = '';
	print '<ul class="menu">';	//	Open the submenu even if there aren't any
	while ($mydata = mysqli_fetch_array($resultvendor)) {
		print "<li><a href=\"vendordetail.php?vendorid={$mydata['vendorid']}\" onclick=\"return hs.htmlExpand(this, { objectType: 'iframe', slideshowGroup: 'Vendor' } )\">{$mydata['bus_name']} <span style=\"font-weight: normal\"> ({$mydata['fname']} {$mydata['lname']})</span></a></li>\n";
		$vendor_printed = true;
	}
	mysql_logout();	//	Disconnect from database

	if (!$vendor_printed) {	//	Did we get any vendors?
		print '<li class="ui-state-disabled">No vendors</li></ul>';	//	No
	} else {
		print '</li></ul>';			//	Close vendor list menu off
	}
	print "</div>";
	
?>
<div id="endDiv">
</div>
</body>
</html>
