<?php
/*	Esprit Dynamic Calendar
	Stephanie Mitchell, 19 March, 2013
	This displays a search form for finding events by title or description. It
	requires that the regpresenter database be set up with a MySQL FULLTEXT
	database on bus_name and bus_desc.
*/

$testing = ($_REQUEST['mode'] ?? 'test');
$standalone = true; //	($_REQUEST['view'] == 'standalone');

$live = !$testing;
define('QUADODO_IN_SYSTEM', true);
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once ".config.php";
require_once ".regconnect.php";
require_once "mysql_utilities.php";
require_once "functions.php";
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="X-UA-Compatible" content="IE=7" /> <!-- Fix for IE 8 shadowbox issues -->
<meta http-equiv="Pragma" content="no-cache" />
<meta name="viewport" content="width=device-width, initial-scale=1.0"/>
<meta http-equiv="Expires" content="-1" />
<!-- meta http-equiv="X-Frame-Options" content="allow-same-origin" / -->
<title><?php print "Esprit $esprit_year Event Calendar Search $test_msg";?></title>
<!-- Include JQuery Core-->
<script type="text/javascript" src="/mgrlib/js/jquery.js"></script>
<script type="text/javascript" src="/mgrlib/js/jquery-ui.js"></script>

<!-- Highslide code -->
<script type="text/javascript" src="/mgrlib/js/highslide/highslide-full.js"></script>
<script type="text/javascript" src="/mgrlib/js/highslide/mobile.js"></script>
<script type="text/javascript" src="../js/highslide-config.js"></script>
<link rel="stylesheet" type="text/css" href="/mgrlib/js/highslide/highslide.css">
<!-- 
<link rel="stylesheet" type="text/css" href="/css/biostyles.css">
 -->

<link href="/css/styles.css" rel="stylesheet" type="text/css" />
<link href="/mgrlib/css/detail-theme/jquery-ui-1.10.0.custom.css" rel="stylesheet" type="text/css" media="all" />
<style>
.formblock {
	border: 1px solid silver;
	background-color: white;
	max-width: 60em;
}
</style>
<!-- place last so it can override jQuery styles-->

<!-- Accordion and highslide initialisation -->
<script>
	$(document).ready(function() {
	  $(".calendarpage").accordion({active: 0,
	  	header: 'h4',
	  	heightStyle: 'content',
	  	collapsible: true});
	});
	/*	Fix highslide graphic directory */
	hs.graphicsDir = '/regdir' + hs.graphicsDir;
	</script>
</head>
<?php
/*
	Sets up and displays the event data in an expanding list.
	This version displays clickable dates that expand into start times that expand into venues and events with times.
*/
mysql_login('Read-only');
print '<body class="calendarpage">';
print "<h2><img src=\"/mgrimg/logo.gif\" alt=\"Esprit Logo\" width=\"420\" height=\"90\" /><br />Esprit $esprit_year Event Search $test_msg</h2>";
print '<body>';
print switchboard();
print '<table width="100%">
<tr><td width="47%">';
print '<div class="formblock">
<form action="daysearch.php" method="post">';
print '<p>Search for an event, class or presentation. <br />Enter one or more words from the event name or description:</p>
 <ul>
 <li class="tiny">Use an asterisk (*) to indicate partial words: for example, "danc*" will find "dance", "dancing", "dances" etc.</li>
<li class="tiny">You can exclude words by prefixing them with a dash ("-")</li>
</ul>';
if (isset($_REQUEST['search_presenter'])) {
	$search_presenter = mysqli_real_escape_string($GLOBALS['dbConnect'], $_REQUEST['search_presenter']);
	print "<p><input type=\"text\" name=\"search_presenter\" id=\"search_presenter\" value=\"$search_presenter\"/>";
} else {
	print '<p><input type="text" name="search_presenter" id="search_presenter" placeholder="enter search words"/>';
}
print '<button type="submit">Go</button></p>';
print '</form>
</div>';
print '</td><td style="width: 6%; text-align: center">- OR -</td><td width="47%">';
print '<div class="formblock">';
print '<form action="daysearch.php" method="post">';
print '<p>Search for a vendor or business name. <br />Enter one or more words from the business name or description:</p>
<ul>
<li class="tiny">Use an asterisk (*) to indicate partial words: for example, "danc*" will find "dance", "dancing", "dances" etc.</li>
<li class="tiny">You can exclude words by prefixing them with a dash ("-")</li>
</ul>';
if (isset($_REQUEST['search_vendor'])) {
	$search_vendor = mysqli_real_escape_string($GLOBALS['dbConnect'], $_REQUEST['search_vendor']);
	print "<p><input type=\"text\" name=\"search_vendor\" id=\"search_vendor\" value=\"$search_vendor\"/>";
} else {
	print '<p><input type="text" name="search_vendor" id="search_vendor" placeholder="enter search words"/>';
}
print '<button type="submit">Go</button></p>';
print '</form>
</div>
</td></tr>
</table>';

switch (true) {
case (isset($_REQUEST['search_presenter'])):
	$search_presenter = mysqli_real_escape_string($GLOBALS['dbConnect'], $_REQUEST['search_presenter']);

	$sql_info = "SELECT r.firstnamepref fname, r.lastnamepref lname,
		s.bus_name bus_name, DATE_FORMAT(s.resourcedate,'%l:%i%p') resourcetime,
		DATE_FORMAT(s.resourcedate,'%W %M %e') resourceday,
		s.resourceroom venue,
		s.resourcedate resourcedate, s.id sessionid,
		DATE_FORMAT(s.resourcedate,'%l:%i%p') resourcestarttime
	FROM reg r
	INNER JOIN regpresenter s ON r.confirmation_no=s.confirmation_no
	WHERE r.is_presenter='Yes'
		AND r.reg_status NOT LIKE '%cancel%'
		AND s.resourcestatus IN ('Approved', 'Scheduled')
		AND MATCH(s.bus_name, bus_desc) AGAINST ('$search_presenter' IN BOOLEAN MODE)";
	break;

case (isset($_REQUEST['search_vendor'])):
	$search_vendor = mysqli_real_escape_string($GLOBALS['dbConnect'], $_REQUEST['search_vendor']);

	$sql_info = "SELECT r.firstnamepref fname, r.lastnamepref lname,
		s.bus_name bus_name, s.bus_desc bus_desc,
		s.resourceroom resourceroom, s.confirmation_no vendorid,
		r.photousage photousage
	FROM reg r
	INNER JOIN regvendor s ON r.confirmation_no=s.confirmation_no
	WHERE r.is_vendor='Yes'
		AND r.reg_status NOT LIKE '%cancel%'
		AND s.resourcestatus IN ('Approved', 'Scheduled')
		AND MATCH(s.bus_name, bus_desc) AGAINST ('$search_vendor' IN BOOLEAN MODE)";
	break;
default:
	die('You haven\'t entered a search yet.');
}

// 	print 'Final SQL query: '.$sql_info;

$result_info = mysqli_query($GLOBALS['dbConnect'], $sql_info) or die('Database error on search query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql_info);

$data = [];
while ($row = mysqli_fetch_assoc($result_info)) {	//	Gather results. Fulltext search sorts by relevance
	$data[] = $row;
// 		print_r($row);
}
mysql_logout();	//	Disconnect from database

if (count($data) == 0) {
	print "<div><h4>Sorry, no results found.<br />Search tips:</h4>";
	print '<ul>
	<li class="tiny">Try alternative forms, such as "dance" or "dancing" or "dances"</li>
	<li class="tiny">Try fewer words</li>
	<li class="tiny">Use an asterisk (*) to indicate partial words: for example, "danc*" will find all the above variations</li>
	<li class="tiny">You can exclude words by prefixing them with a dash ("-")</li>
	<li class="tiny">Don\'t use short or common words like "the, and, he, she" etc.</li>
	</ul>';
} else {
	print '<div>';
	print "<p>Search results, sorted by relevance. Click result headings for details.</p>";
	if (isset($_REQUEST['search_presenter'])) {
		foreach ($data as $this_result) {
			print "<p><a href=\"eventdetail.php?sessionid={$this_result['sessionid']}\" onclick=\"return hs.htmlExpand(this, { objectType: 'iframe', slideshowGroup: 'results'} )\">";
			print "<strong>{$this_result['bus_name']}</strong></a> {$this_result['resourceday']} {$this_result['venue']} {$this_result['resourcestarttime']}</p>";
		}
	}
	if (isset($_REQUEST['search_vendor'])) {
		foreach ($data as $this_result) {

			print "<p><a href=\"../bios/vendordetail.php?vendorid={$this_result['vendorid']}\" onclick=\"return hs.htmlExpand(this, { objectType: 'iframe', slideshowGroup: 'results'} )\">";
			print "<strong>{$this_result['bus_name']}</strong></a> {$this_result['venue']}</p>";
		}
	}
}
print '</div>';
?>
