<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 23 November, 2017
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');
global $opts, $all_years;

/* MySQL table names */

if ($all_years) {	//	Dummy logic in case we add years later
	$db['tb'] = 'regaddons r';
	$db['tbnoalias'] = 'regaddons';
} else {
	$db['tb'] = 'regaddons r';
	$db['tbnoalias'] = 'regaddons';
}
$opts['join_clause'] = '';
/* Field definitions start here */
// print "\$all_years: $all_years";
if ($all_years and false) {	//	Disabled; no Esprit_year field in regaddons yet
	$fields['esprit_year'] = [
			'heading' => "Esprit Year",
			'table' => 'r',
			'select' => true,
			'display' => true,
			'fieldgroup' => '*, Master',
	// 		'copyValue' => '9999',	//	Uncomment to test copyValue
			'width' => '8%',
			'search_more' => false,
			'filter' => ""];
}
// print "\$all_years=$all_years, \$db[tb]={$db['tb']}";
$fields['addon_id'] = [
		'heading' => "Item ID",
		'table' => 'r',
		'display' => true,
		'width' => "5%",
		'fieldgroup' => 'Master,*',
		'primarykey' => true,
		'filter' => ""];
$fields['addon_parent'] = [
		'heading' => "Parent ID",
		'table' => 'r',
		'display' => true,
		'width' => "8%",
		'fieldgroup' => 'Master, Detail',
		'arrayedit' => true,
		'filter' => ""];
$fields['addon_type'] = [
		'heading' => "Item Type",
		'table' => 'r',
		'display' => true,
		'width' => "8%",
		'fieldgroup' => '*, Master',
		'arrayedit' => true,
		'filter' => ""];
$fields['addon_online_esprit'] = [
		'heading' => "Online?",
		'long_heading' => "Use for ONLINE Esprit?",
		'table' => 'r',
		'display' => true,
		'width' => '20%',
		'widget' => 'menu',
		'allowedvalues' => ["Yes", "No"],
		'allowedlabels' => ["Yes", "No"],
		'arrayedit' => true,
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['addon_name'] = [
		'heading' => "Item Name",
		'long_heading' => "Addon Name",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'fieldgroup' => '*, Master',
		'arrayedit' => true,
		'filter' => ""];
$fields['addon_read_more'] = [
		'heading' => "Read_More",
		'long_heading' => "Text for \"Read More\" button",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'fieldgroup' => '*',
		'filter' => ""];
$fields['addon_desc'] = [
		'heading' => "Description",
		'long_heading' => "Addon Description",
		'table' => 'r',
		'display' => true,
		'widget' => 'ckeditor',
		'fieldgroup' => '*',
		'filter' => ""];
$fields['addon_desc_link'] = [
		'heading' => "Item Link",
		'table' => 'r',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => 'Master, Detail',	//	No copy to new
		'filter' => ""];
$fields['addon_price'] = [
		'heading' => "Unit Price",
		'long_heading' => "Cost of Addon",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'fieldgroup' => 'Master,*',
		'copyvalue' => 0,
		'filter' => ""];
$fields['tax'] = [
		'heading' => 'Tax',
		'long_heading' => "Sales Tax",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'fieldgroup' => 'Master,*',
		'copyvalue' => 0,
		'filter' => ""];
$fields['addon_direct_amount'] = [
		'heading' => "Allow direct entry of amount?",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'widget' => 'menu',
		'allowedvalues' => ['Yes', 'No'],
		'allowedlabels' => ['Yes', 'No'],
		'arrayedit' => true,
		'fieldgroup' => 'Master,*',
		'filter' => ""];
$fields['addon_weekday'] = [
		'heading' => "Weekday",
		'long_heading' => "Weekday for Addon",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'widget' => 'menu',
		'allowedvalues' => ['', 'S1', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa', 'S2'],
		'allowedlabels' => ['daysun1', 'daymon', 'daytue', 'daywed', 'daythu', 'dayfri', 'daysat', 'daysun2'],
		'arrayedit' => true,
		'fieldgroup' => 'Master,*',
		'filter' => ""];
$fields['addon_stocklimit'] = [
		'heading' => "Stock Limit",
		'long_heading' => "Max. Available",
		'labelhelp' => "0=no limit",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'fieldgroup' => 'Master,*',
		'copyValue' => 0,
		'filter' => ""];
$fields['addon_max_signup'] = [
		'heading' => "Signup Max",
		'long_heading' => "Limit per registration",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'fieldgroup' => 'Master,*',
		'copyValue' => 0,
		'filter' => ""];
$fields['addon_tier1'] = [
		'heading' => "Tier1",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'widget' => 'checkboxyn',
		'fieldgroup' => 'Master,*',
		'copyValue' => 0,
		'filter' => ""];
$fields['addon_tier2'] = [
		'heading' => "Tier2",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'widget' => 'checkboxyn',
		'fieldgroup' => 'Master,*',
		'copyValue' => 0,
		'filter' => ""];
$fields['addon_tier3'] = [
		'heading' => "Tier3",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'widget' => 'checkboxyn',
		'fieldgroup' => 'Master,*',
		'copyValue' => 0,
		'filter' => ""];
$fields['addon_tier4'] = [
		'heading' => "Tier4",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'widget' => 'checkboxyn',
		'fieldgroup' => 'Master,*',
		'copyValue' => 0,
		'filter' => ""];
$fields['addon_tier5'] = [
		'heading' => "Tier5",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'widget' => 'checkboxyn',
		'fieldgroup' => 'Master,*',
		'copyValue' => 0,
		'filter' => ""];
$fields['addon_tier6'] = [
		'heading' => "Tier6",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'widget' => 'checkboxyn',
		'fieldgroup' => 'Master,*',
		'copyValue' => 0,
		'filter' => ""];
$fields['addon_show'] = [
		'heading' => "Show On Forms",
		'labelhelp' => "Labelhelp should be overridden",
		'table' => 'r',
		'display' => true,
		'width' => '20%',
		'arrayedit' => true,
		'fieldgroup' => 'Master,*',
		'filter' => ""];
$fields['addon_postprocess'] = [
		'heading' => "Postprocess function",
		'labelhelp' => "Use with EXTREME care!",
		'table' => 'r',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['addon_ft_exclude'] = [
		'heading' => "Exclude First-timer",
		'labelhelp' => "Exclude for first-time attendees",
		'table' => 'r',
		'display' => true,
		'arrayedit' => true,
		'widget' => 'menu',
		'allowedvalues' => ['Yes', 'No'],
		'allowedlabels' => ['Yes', 'No'],
		'fieldgroup' => '*',
		'filter' => ""];
$fields['addon_create'] = [
		'heading' => "Record created",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Master, Detail',	//	No copy to new
		'filter' => ""];
$fields['addon_update'] = [
		'heading' => "Record updated",
		'table' => 'r',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'fieldgroup' =>  'Master, Detail',	//	No copy to new
		'filter' => ""];

/* End of Field definitions. */

if (! $all_years) {/* Field group definitions (current year) */

$tpl['fieldgroups'] = [
/*	'Blank' => ['label' => '>',
		'url' => 'blank.php'], */
	'Master' => ['label'=>'Master',
		'url' =>''],
	'Detail' => ['label' => 'Details',
		'url' => 'taburl.php?template=addons_detail.tpl',
		'authgroup' => ['Admin', 'Registrar']],
	'AddNew' => ['label' => 'Copy',
		'url' => 'add.php',
		'authgroup' => ['Admin', 'Registrar'],
		'scroll' => 'No'],	//	Prevent scrolling to this screen
	'Child' => ['label' => 'Create Child',
		'url' => 'create_child.php',
		'authgroup' => ['Admin', 'Registrar'],
		'scroll' => 'No'],	//	Prevent scrolling to this screen
	'DeleteThis' => ['label' => 'Delete',
		'url' => 'delete.php',
		'authgroup' => ['Admin', 'Registrar'],
		'scroll' => 'No'	//	Prevent scrolling to this screen
		],
	'Logs' => ['label' => 'Log Entries',
		'url' => "../log-list.php?tbname={$db['tbnoalias']}",
		'width' => 1500,
		'height' => 800,
		'authgroup' => ['Admin']]
];
} else {
$tpl['fieldgroups'] = [
/*	'Blank' => ['label' => '>',
		'url' => 'blank.php'], */
	'Master' => ['label'=>'Master',
		'url' =>''],
	'Detail' => ['label' => 'Details',
		'url' => 'taburl.php?template=addons_detail.tpl&access=read_only&all_years=true',
		'authgroup' => ['Admin']],
	'AddNew' => ['label' => 'Copy',
		'url' => 'add.php',
		'authgroup' => ['Admin'],
		'scroll' => 'No'],	//	Prevent scrolling to this screen
	'Logs' => ['label' => 'Log Entries',
		'url' => "../log-list.php?tbname={$db['tbnoalias']}",
		'width' => 1500,
		'height' => 800,
		'authgroup' => ['Admin']]
];
}

?>