<?php
/*	This file "deletes" a registration given its entry number. It's
	intended to be called from the Utilities tab of the Participants screen.
	Note that it does't really delete the record; it just changes the reg_status
	field to "DELETED". The view "reg" on the master "regall" database
	specifically excludes "DELETED" records, so this effectively removes the
	record from selection without actually destroying it. Undeletes are
	therefore possible, if awkward.
	
	Parameter is ?entrynum=x, where x is the entry number of the reg record. This will always be unique, unlike the confirmation - which should be, but might not be in the case of problems.
	
	Stephanie Mitchell, 8 November, 2017
*/
/*
	See if logged in via Quadodo
*/
global $tpl;
define('QUADODO_IN_SYSTEM', true);
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once "header.php";
$tpl['authgroup'] = $qls->group_id_to_name($qls->user_info['group_id']);
$tpl['username'] = $qls->user_info['username'];
if ($tpl['username'] == '') {
header('Location: /qls/login.php');
exit;
}

$primarykeyfieldvalue = $_REQUEST['pkfv'];
$primarykeyfieldname = $_REQUEST['pkfn'];
$group = $_REQUEST['group'];

require_once ".config.php";
require_once "fieldlist.php";
require_once "template_options.php";
require_once "mysql_utilities.php";
mysql_login('Normal');

mysql_login();
print '<link href="css/styles.css" rel="stylesheet" type="text/css" media="all">';

$entrynum = $_REQUEST['entrynum'];

if ($entrynum == '') {
	SM_Die('Missing entrynum (entry number) when attempting to mark registration as deleted.', 'No registration specified for deletion.');
	}

$sql = "UPDATE reg SET reg_status='DELETED' WHERE entrynum=$entrynum";

// print 'Final SQL query: '.$sql;

$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error while marking registration deleted: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Marking record as deleted failed - sorry!');

// Add log file entry

$sql_escaped =  mysqli_real_escape_string($GLOBALS['dbConnect'], $sql);
Make_Log_Entry($GLOBALS['dbConnect'], "REGISTRATION DELETED: $sql_escaped");
mysql_logout();	//	Disconnect from database

print '<span class="warning">DELETED</span>';
print "<p>$msg<br/><br /><a href=\"index.php\">Refresh</a>";

?>