<?php
/*	This file generates a list of the volunteer signups applicable to a 
	particular person. The person is identified by their confirmation number.
	The list is intended for inclusion in an iframe in the accounts_detail.tpl
	template:
	
		<iframe src="volunteer-list.php?confirmation={$mydata.confirmation_no}&submit={$mydata.timestamp}" height="150" width="500"></iframe>

*/
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");	// WAAAY in the past
header("Cache-Control: no-cache");
header("Pragma: no-cache");
print '<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">';
print '<style>
.tiny {		/*	For annotations */
	font-size: 0.75em;
}
</style>';
print '<link href="/css/styles.css" rel="stylesheet" type="text/css" media="all">';
print '<link href="/css/reports.css" rel="stylesheet" type="text/css" media="all">';

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";

require_once "mysql_utilities.php";
print "<script type=\"text/javascript\" src=\"/lib/js/jquery.js\"></script>";

mysql_login('Normal');

$confirmation_no = $_REQUEST['confirmation'];
$this_submit = $_REQUEST['submit'];
$no_post = isset($_REQUEST['no_post']);
$authgroup = $_REQUEST['authgroup'];
// Force caching to expire ASAP or displayed payment info is out of date
//	print '<pre>';print_r($_REQUEST);print '</pre><br />';

/*	Include a mini-form for adding a new activity. Only do this if there is NOT
	a no_post parameter (e.g. if this is called from the attendees screen, as
	opposed to the attendessall screen).*/

print '<form name="miniform" id="miniform_id" accept-charset="UTF-8" action="volunteer_add.php" method="POST">';

define ('QUADODO_IN_SYSTEM', true);

print '<table class="row-0">';
if (empty($confirmation_no)) {
	print '<tr><td></td><td class="warning">Missing confirmation no. Cannot locate signups.</tr>';
} else {
	$sql = "SELECT voltype_name
	FROM regvolunteertypes
	ORDER BY voltype_order";	//	Get available volunteer types
	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error while selecting volunteer types: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to retrieve volunteer types for display. Sorry!');
	$voltypes = mysqli_fetch_all($result, MYSQLI_ASSOC);
	
	print '<tr class="row-1"><td width="20%">Timestamp</td>
	<td>Type</td>
	<td></td>
	</tr>';

	$sql = "SELECT v.id id, v.vol_created vol_created, v.vol_updated vol_updated, v.vol_typename vol_typename
	FROM regvolunteers v WHERE vol_confirmation=$confirmation_no
	ORDER BY v.vol_created";
	
	// print 'Final SQL query: '.$sql;
	
	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to retrieve volunteer signups for display. Sorry!');
	
	while ($row = mysqli_fetch_array($result)) {
		print '<tr>
		<td>'.$row['vol_created'].'</td>
		<td>'.$row['vol_typename'].'</td>
		<td>';
		print (in_array($authgroup, ['Admin','Volunteer']) & !$no_post)
			? "<a href=\"volunteer_delete.php?id={$row['id']}&confirmation=$confirmation_no&authgroup=$authgroup\" onclick=\"return confirm('Are you sure you want to delete?')\">
			<img src=\"/images/sm_delete.png\"></a>"
			: '&nbsp;';
		print '</td></tr>';
	}
mysql_logout();	//	Disconnect from database
}
if (!$no_post) {
	print "<tr class=\"row-0\">
	<td><input type=\"hidden\" name=\"confirmation\" id=\"confirmation\" value=$confirmation_no /><input type=\"hidden\" name=\"authgroup\" id=\"authgroup\" value=\"$authgroup\" /></td>
	<td><select name=\"vol_typename\" id=\"_vol_typename\">";
	print '<option value="">Please select an activity and post...</option>';
	foreach ($voltypes as $thiskey => $thisitem) {
		print "<option value=\"{$thisitem['voltype_name']}\" >{$thisitem['voltype_name']}</option>\n";
	}
	print '</select></td>';
	print '<td><input type="image" src="/images/sm_add.png" onclick="this.form.submit;"></td>';
}
print '</tr>';
print '</table>';
print '</form>';
?>