<?php
/*
	Esprit Registration System
	by Stephanie Mitchell
	21 August, 2016
	
	This file sets up important constants for the entire Registration
	and Scholarship Application system. It is also used by the stats charting
	package for setting the current Esprit year.
	
	Set up deadlines and cutoffs.
*/

/*
	Testing switch. Needs to be set before anything else as it also controls
	error reporting.
*/

global $test_msg;
define('TESTING', false);		//	change to true while debugging. Suppresses
								//	emails to Esprit Registrar, among other
								//	things
define('SHOW_ERRORS', false);	//	controls error reporting. False during
								//	production but may be set to true while
								//	debugging and developing.
if (SHOW_ERRORS and TESTING) {	//	Never show errors in production mode
	ini_set('display_startup_errors',1);
	ini_set('display_errors',1);
	error_reporting(-1);		//	All errors
}
ini_set('date.timezone', 'America/Los_Angeles');

define('_LOGFILENAME', 'reglog'); 	//	Log file name
define('_DBNAME', 'esprit');		//	Database name

/*	Protect from non-logged in users */

defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');

global $esprit_year, $esprit_start, $esprit_end;
$esprit_year = 2017;	// 4-digit year of the Esprit being processed

/*	$esprit_week_shift accounts for when the dates of Esprit shift by a week
	within the month. It's normally zero, but needs to be set to 1 when the date
	of Esprit moves forward a week. This is significant when cloning events from
	one year to the next. Cloning an event means recalculating its dates to land
	on the same relative weekday - but it must take into account the one-week
	shift in such cases. For example, in 2016 Esprit began on 8 May. in 2017 it
	began on 14 May (not 7 May), so $esprit_week_shift must be set to 1.
*/

global $esprit_week_shift;
$esprit_week_shift = 1;	//	Going from 2016 (May 8) to 2017 (May 14)

global $regsystemversion;
$regsystemversion = 'Esprit Registration System Version 1.7.0';

/*
	Package date override. Set in URL; if set to "PKO" (all caps), returns
	package	rates for date specified in URL instead of	actual date,
	irrespective of value of TESTING.
*/
global $pko;
$pko = (isset($_REQUEST['pko']) ? $_REQUEST['pko'] == 'PKO' : false);

global $today_text, $today, $test_msg, $auto_login_ids;

if (TESTING or $pko) {	// If we're testing, we can specify ?date=yyyy-mm-dd in
						// the URL to check the logic for different dates
	$today_text = (isset($_REQUEST['date']) ? $_REQUEST['date'] : 'now');
	$test_msg = 'TEST';
} else {
 	$today_text = 'now';
 	$test_msg = '';
}
$today = strtotime($today_text);
// print 'Today: '.strftime('%F %T %Z', $today).'<br />';	// uncomment for testing
$today_text = strftime('%B %e, %Y', $today);	// fix for printing

/*
	These unlock/override keys are generated using MD5. The actual source phrase
	is unimportant. Only these 32-character strings are distributed.
*/
/*	Unlocks Scholarship dates */
global $scholarship_override;
$scholarship_override = '2700533b470e1a1b82d48330fe5b3739';
/*	Unlocks special reg forms */
global $committee_override;
$committee_override = '8b617a6f69f7c8bfc59f35cfca7fbedd';
/*	Unlocks presenter forms */
global $presenter_override;
$presenter_override = 'a9d551ddc6bb91ff4ffbfd957c43ebf0';
/*	Unlocks vendor forms */
global $vendor_override;
$vendor_override = '654b277be11860403e8c8fd11d763036';

/*
	Important dates for Esprit.
	
	Keep the following dates in this order, ascending, for consistency.
	
	Make sure you enter the dates in a pleasingly human-readable format such as
	that shown, as they are included as-is in many forms and emails.
	
	Dates that have "deadline" in their name will automatically have "23:59"
	appended to them so that the actual deadline time is at the end of that day,
	not the beginning. However the 23:59 doesn't print as part of the date text.
*/

/*	Registration cap for Esprit. Maximum number of registrations we can accept.
	Currently there is NO CODE TO ENFORCE THIS. */
	
global $esprit_cap;
$esprit_cap = 150;

global $date_text;

// Start and end dates for Esprit
$date_text['esprit_start'] = 'May 14th, 2017';				// first Sunday of Esprit
$date_text['esprit_end'] = 'May 21st, 2017';				// last Sunday of Esprit

//	Registration dates
$date_text['registration_open'] = 'January 8th, 2017';		// usually first of a month,
													// delayed in 2017
$date_text['registration_deadline'] = 'May 20th, 2017';	// last Saturday of Esprit
$date_text['registration_closed'] = 'May 21st, 2017';		// day after above
													// = esprit_end
$date_text['payment_deadline'] = 'April 28th, 2017';		// Friday 2 wk before Esprit

/*
	Vendor and Presenter Special registration dates. These allow vendors and 
	presenters to register before the rest of the world.
*/
$date_text['vendor_registration_open'] = 'November 1st, 2016';		//	typically ASAP
$date_text['vendor_registration_deadline'] = 'April 8th, 2017'; 		//	Friday of precon
$date_text['presenter_registration_open'] = 'November 1st, 2016';
$date_text['presenter_registration_deadline'] = 'April 8th, 2017'; // Friday of precon

/*
	Committee Special registration date. This allows Committee members to
	register before the rest of the world.
*/
$date_text['committee_registration_open'] = 'November 1st, 2016';	// typically ASAP

//	Special registration dates
$date_text['onsite_registration_open'] = 'May 14th, 2017';	// = esprit_start

/*
	Next two entries are for meal package calculations for late walk-ins. Set to
	last Thursday and Friday of Esprit.
*/
$date_text['onsite_registration_open_thursday'] = 'May 18th, 2017';
$date_text['onsite_registration_open_friday'] = 'May 19th, 2017';

//	Registration closed date. Must match esprit_end above.
$date_text['onsite_registration_closed'] = 'May 21st, 2017';

//	Tiered rate structure dates.
$date_text['tier1'] = $date_tetxt['registration_open'];		//	must match
$date_text['tier2'] = 'February 8th, 2017';			//	one month window
$date_text['tier3'] = 'March 8th, 2017';			//	one month window
$date_text['tier4'] = 'April 8th, 2017';			//	one month window
$date_text['tier5'] = $date_text['esprit_start'];	//	walk-ins, matches esprit_start

//	Refund dates
$date_text['refund_full_deadline'] = 'March 17th, 2017';	// Friday nearest 15 March
$date_text['refund_full_closed'] = 'March 18th, 2017';		// day after above
$date_text['refund_50_deadline'] = 'April 14th, 2017';		// Friday before 15 April
$date_text['refund_50_closed'] = 'April 15th, 2017';		// day after above

//	Scholarship dates
$date_text['scholarships_open'] = 'January 8th, 2017';	// = registration_open
$date_text['scholarships_deadline'] = 'April 24th, 2017';	// normally last day of March
$date_text['scholarships_closed'] = 'April 25th, 2017';		// day after above

//	Evaluation dates
$date_text['evaluations_open'] = 'May 17th, 2017';		// 4 days before Esprit ends
$date_text['evaluations_closed'] = 'July 31st, 2017';	// end of July following Esprit

/*
	Veterans' Breakfast (now held only in odd-numbered years, if at all). Set
	this to true to enable ratetable.php to ask applicants if they want to
	attend, false to omit that code and set the meal count to 0. Also affects
	various reports and things on the back end.
*/
	global $meal1enabled;	//	Veterans' Breakfast is meal no 1.
	$meal1enabled = false;

global $date;

/*
	Parse all date strings defined above into actual dates so we can do math
	on them. If the date's name includes "deadline", append midnight to the date
	while parsing.
*/
foreach ($date_text as $k => $d) {
	if (strpos($k, 'deadline')>0) {
		$d .=' 23:59';
	}
	$date[$k] = strtotime($d);
// 	print "$k: ".strftime('%F %T %Z', $date[$k]).'<br />';	// uncomment for testing
}

$esprit_start = strftime('%F', $date['esprit_start']);	//	yyyy/mm/dd, used in some reports
$esprit_end = strftime('%F', $date['esprit_end']);	//	yyyy/mm/dd, used in some reports

$check = array();

/*
	Set up a bunch of flags that will simplify date checking elsewhere in the
	system.
*/
global $check;

$check['registration_not_yet_open'] = ($today < $date['registration_open']);
$check['preregistration_open'] = (($today >= $date['registration_open'])
				and ($today <= $date['registration_deadline']));
$check['vendor_preregistration_open'] = (($today >= 
				$date['vendor_registration_open'])
				and ($today <= $date['vendor_registration_deadline']) or ($_REQUEST['override'] == $vendor_override));
$check['vendor_registration_not_yet_open'] = ($today <
				$date['vendor_registration_open']);
$check['presenter_preregistration_open'] = (($today >= 
				$date['presenter_registration_open'])
				and ($today <= $date['presenter_registration_deadline']) or ($_REQUEST['override'] == $presenter_override));
$check['presenter_registration_not_yet_open'] = ($today < $date['presenter_registration_open']);
$check['committee_preregistration_open'] = (($today >= 
				$date['committee_registration_open'])
				and ($today <= $date['registration_deadline']));
$check['committee_registration_not_yet_open'] = ($today < $date['committee_registration_open']);
$check['preregistration_closed'] = ($today > $date['registration_deadline']);
$check['onsite_registration_open'] = (($today >= $date['onsite_registration_open'])
				and ($today < $date['onsite_registration_closed']));
$check['onsite_registration_closed'] = ($today > $date['onsite_registration_closed']);
$check['onsite_registration_open_thursday'] = (($today >= $date['onsite_registration_open_thursday'])
				and ($today < $date['onsite_registration_closed']));
$check['onsite_registration_open_friday'] = (($today >= $date['onsite_registration_open_friday'])
				and ($today < $date['onsite_registration_closed']));
/* No incentive discount ever. Original line was:
$check['incentive_available'] = (($today >= $date['registration_open'])
				and ($today <= $date['incentive_deadline']));*/
$check['incentive_available'] = false;
// $check['incentive_deadline'] = ($today <= $date['incentive_deadline']);

$check['scholarships_not_yet_open'] = ($today < $date['scholarships_open']);
$check['scholarships_open'] = (($today >= $date['scholarships_open'])
				and ($today <= $date['scholarships_deadline']));
$check['scholarships_closed'] = ($today > $date['scholarships_deadline']);
$check['evaluations_not_yet_open'] = ($today < $date['evaluations_open']);
$check['evaluations_open'] = (($today >= $date['evaluations_open'])
				and ($today < $date['evaluations_closed']));
$check['evaluations_closed'] = ($today > $date['evaluations_closed']);
$check['registration_open'] = ($check['preregistration_open'] or $check['onsite_registration_open']);
$check['payment_deadline'] = ($today >= $date['payment_deadline']);
$check['refund_full'] = ($check['preregistration_open']
				and ($today <= $date['refund_full_deadline']));
$check['refund_50'] = ($check['preregistration_open']
				and ($today <= $date['refund_50_deadline'])
				and ($today > $date['refund_full_deadline']));
$check['refund_none'] = ($check['preregistration_open']
				and ($today > $date['refund_50_deadline']));
/*	Tiered rate structure checks. Note that ['rate_tier']['1'] does not check
	against tier1; this is because certain registration categories open
	before regular registration and need to be accommodated. */	
$check['rate_tier']['1'] = ( ($today < $date['tier2']));
$check['rate_tier']['2'] = (($today >= $date['tier2'])
	and ($today < $date['tier3']));
$check['rate_tier']['3'] = (($today >= $date['tier3'])
	and ($today < $date['tier4']));
$check['rate_tier']['4'] = (($today >= $date['tier4'])
	and ($today < $date['tier5']));
$check['rate_tier']['5'] = (($today >= $date['tier5'])
	and ($today < $date['esprit_end']));
/*	History book discount availability */
$check['hist_book_available'] = false; //($today <= $date['hist_book_deadlne']);

/*
	Set up scholarship prorate parameters.
*/
//	Factor an applicant is docked for multiple awards
global $schol_percent_dock;
$schol_percent_dock = 0.25;
//	Maximum factor an applicant can be docked
global $schol_max_dock;
$schol_max_dock = 1;
//	Maximum awards an applicant can ever receive. 0 means no limit.
global $schol_max_award_count;
$schol_max_award_count = 0;

/*
	Set up meal names. Saves hard-coding them everywhere.
*/

global $mealnames;
$mealnames = array(
	'meal1' => array(
		'verbose' =>'Friday Veterans\' Breakfast',
		'long' => 'Veterans\' Breakfast',
		'abbr' => 'Fri. Breakfast',
		'enabled' => $meal1enabled,	//	Set above; true only if meal is
										//	offered this year
		'cost' => 21),
	'meal2' => array(
		'verbose' =>'Friday Lunch and Fashion Show',
		'long' => 'Friday Lunch',
		'abbr' => 'Fri. Lunch',
		'enabled' => true,
		'cost' => 23),
	'meal3' => array(
		'verbose' =>'Friday Dinner and Talent Night',
		'long' => 'Friday Dinner',
		'abbr' => 'Fri. Dinner',
		'enabled' => true,
		'cost' => 37),
	'meal4' => array(
		'verbose' =>'Saturday Lunch and Keynote',
		'long' => 'Saturday Lunch',
		'abbr' => 'Sat. Lunch',
		'enabled' => true,
		'cost' => 22),
	'meal5' => array(
		'verbose' =>'Saturday Dinner and Gala',
		'long' => 'Saturday Dinner',
		'abbr' => 'Sat. Dinner',
		'enabled' => true,
		'cost' => 42),
	'meal6' => array(
		'verbose' => 'Sunday Farewell Brunch',
		'long' => 'Sunday Brunch',
		'abbr' => 'Sun. Brunch',
		'enabled' => true,
		'cost' => 22)
	);

/*
	Set up special meal request options. These are included in the registration forms as checkboxes. This is jut a convenient place to store them.
*/

global $specialmealrequests;
$specialmealrequests = array(
	"Vegetarian","Gluten_Free"
	);

/*
	Create rate package arrays. Several arrays are created, depending on whether
	it's the middle of onsite registration.
	
	Meals are represented by an array of six values for each package, thus
	providing for six meals. These are typically Friday lunch and dinner,
	Saturday lunch and dinner and Sunday brunch. The Veteran's Breakfast was
	added on Friday morning in 2015.
	
	'discountable' is true if the package is eligible for the prompt payment
	discount can be applied to a package, false if it isn't (e.g. committee
	rates and onsite walkins can't be discounted). NOTE that as of 2014 the
	discounting mechanism was discontinued in favour of the tiered rate system,
	so its code is commented out.
	
	'mealselectone' is true if the package requires the attendee to select a
	single meal of their choice.
	
	For Esprit 2016 the Veterans' Breakfast is held only every other year,
	beginning with it NOT being held in 2016. Rather than hard-code the
	alternation, $meal1enabled is manually set to true or false near the
	beginning of this file. Nothing else in this config file changes; the only
	thing controlled by $meal1enabled is whether ratetable.php asks if people
	want to attend the Veterans' Breakfast.

*/

global $packages;	//	Saves a gazillion includes everywhere

/*	Full Rates. Implement tiered (incrementing( rate structure by creating this
	base array, then reinitialising the ['Full Rate']['Single'] portion of it to
	the incremented values. This works because tiering only applies to the
	Single registration; other type of registration are unaffected. If other
	rates were to be subjected to tiering they would need to be added to the
	additional reinitialisations below. */

/*	Day arrays for conciseness. Eight-element arrays representing Sunday-Sunday.
	1=included in stay, 0=not included */

$daysunsun = array(1,1,1,1,1,1,1,1);
$daywedsun = array(0,0,0,1,1,1,1,1);
$daythusun = array(0,0,0,0,1,1,1,1);
$dayfrisun = array(0,0,0,0,0,1,1,1);
$day1mon = array(0,1,0,0,0,0,0,0);	//	Single Friday
$day1tue = array(0,0,1,0,0,0,0,0);	//	Single Saturday
$day1wed = array(0,0,0,1,0,0,0,0);	//	Single Friday
$day1thu = array(0,0,0,0,1,0,0,0);	//	Single Saturday
$day1fri = array(0,0,0,0,0,1,0,0);	//	Single Friday
$day1sat = array(0,0,0,0,0,0,1,0);	//	Single Saturday
$daynone = array(0,0,0,0,0,0,0,0);	//	For manually selected days
$daynames = array(
	'daysun1' => array('long' => 'Sunday 1', 'short' => 'Sun1', 'abbr' => 'S1'),
	'daymon' => array('long' => 'Monday', 'short' => 'Mon', 'abbr' => 'Mo'),
	'daytue' => array('long' => 'Tuesday', 'short' => 'Tue', 'abbr' => 'Tu'),
	'daywed' => array('long' => 'Wednesday', 'short' => 'Wed', 'abbr' => 'We'),
	'daythu' => array('long' => 'Thursday', 'short' => 'Thu', 'abbr' => 'Th'),
	'dayfri' => array('long' => 'Friday', 'short' => 'Fri', 'abbr' => 'Fr'),
	'daysat' => array('long' => 'Saturday', 'short' => 'Sat', 'abbr' => 'Sa'),
	'daysun2' => array('long' => 'Sunday 2', 'short' => 'Sun2', 'abbr' => 'S2')
);
$mealall = array(1,1,1,1,1,1);
$mealall[0] = ($meal1enabled ? 1 : 0);	//	Adjust for Veterans' Breakfast flag
$mealnone = array(0,0,0,0,0,0);
$mealfrisun = array(0,1,1,1,1,1);
$mealfrionly = array(0,1,1,0,0,0);
$mealsatonly = array(0,0,0,1,1,0);
$packages['Full Rate'] = array(
	'Single' => array(
		'Sun - Sun' => array(
			'code' => 'SS-I-FR', 'rate' => 440,
			'notes' => 'Single Full Rate Sun-Sun',
			'days' => $daysunsun,
			'meals' => $mealall, 'discountable' => false),
		'Wed - Sun' => array(
			'code' => 'WS-I-FR', 'rate' => 390,
			'notes' => 'Single Full Rate Wed-Sun',
			'days' => $daywedsun,
			'meals' => $mealall, 'discountable' => false),
		'Fri - Sun' => array(
			'code' => 'FS-I-FR', 'rate' => 320,
			'notes' => 'Single Full Rate Fri-Sun',
			'days' => $dayfrisun,
			'meals' => $mealfrisun, 'discountable' => false),
		'Mon Only' => array(
			'code' => '1M-I-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1mon,
			'notes' => 'Single Monday only',
			'meals' => $mealnone, 'discountable' => false),
		'Tue Only' => array(
			'code' => '1T-I-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1tue,
			'notes' => 'Single Tuesday only',
			'meals' => $mealnone, 'discountable' => false),
		'Wed Only' => array(
			'code' => '1W-I-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1wed,
			'notes' => 'Single Wednesday only',
			'meals' => $mealnone, 'discountable' => false),
		'Thu Only' => array(
			'code' => '1R-I-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1thu,
			'notes' => 'Single Thursday only',
			'meals' => $mealnone, 'discountable' => false),
		'Fri Only' => array(
			'code' => '1F-I-SR',
			'rate' => 115 + $mealnames['meal2']['cost'] + $mealnames['meal3']['cost'],	//	Add Fri meals (meal2 and meal3)
			'days' => $day1fri,
			'notes' => 'Single Friday only',
			'meals' => $mealfrionly, 'discountable' => false),
		'Sat Only' => array(
			'code' => '1A-I-SR',
			'rate' => 136 + $mealnames['meal4']['cost'] + $mealnames['meal5']['cost'],	//	Add Sat meals (meal4 and meal5)
			'days' => $day1sat,
			'notes' => 'Single Saturday only',
			'meals' => $mealsatonly, 'discountable' => false),
// 		'Sun-Sun NO MEALS' => array(
// 			'code' => 'SS-I-SR', 'rate' => 310,
// 			'days' => $daysunsun,
// 			'notes' => 'Single NO MEALS Sun-Sun',
// 			'meals' => $mealnone, 'discountable' => false)
		),
	'SO' => array(
		'Sun - Sun' => array(
			'code' => 'SS-S-FR', 'rate' => 280,
			'notes' => 'SO Full Rate Sun-Sun',
			'days' => $daysunsun,
			'meals' => $mealall, 'discountable' => false),
		'Wed - Sun' => array(
			'code' => 'WS-S-FR', 'rate' => 240,
			'notes' => 'SO Full Rate Wed-Sun',
			'days' => $daywedsun,
			'meals' => $mealall, 'discountable' => false),
		'Fri - Sun' => array(
			'code' => 'FS-S-FR', 'rate' => 210,
			'notes' => 'SO Full Rate Fri-Sun',
			'days' => $dayfrisun,
			'meals' => $mealfrisun, 'discountable' => false),
		'Mon Only' => array(
			'code' => '1M-S-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1mon,
			'notes' => 'SO Monday only',
			'meals' => $mealnone, 'discountable' => false),
		'Tue Only' => array(
			'code' => '1T-S-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1tue,
			'notes' => 'SO Tuesday only',
			'meals' => $mealnone, 'discountable' => false),
		'Wed Only' => array(
			'code' => '1W-S-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1wed,
			'notes' => 'SO Wednesday only',
			'meals' => $mealnone, 'discountable' => false),
		'Thu Only' => array(
			'code' => '1R-S-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1thu,
			'notes' => 'SO Thursday only',
			'meals' => $mealnone, 'discountable' => false),
		'Fri Only' => array(
			'code' => '1F-S-SR',
			'rate' => 115 + $mealnames['meal2']['cost'] + $mealnames['meal3']['cost'],	//	Add Fri meals (meal2 and meal3)
			'days' => $day1fri,
			'notes' => 'SO Friday only',
			'meals' => $mealfrionly, 'discountable' => false),
		'Sat Only' => array(
			'code' => '1A-S-SR',
			'rate' => 136 + $mealnames['meal4']['cost'] + $mealnames['meal5']['cost'],	//	Add Sat meals (meal4 and meal5)
			'days' => $day1sat,
			'notes' => 'SO Saturday only',
			'meals' => $mealsatonly, 'discountable' => false),
// 		'Sun-Sun NO MEALS' => array(
// 			'code' => 'SS-S-SR', 'rate' => 150,
// 			'notes' => 'SO NO MEALS Sun-Sun',
// 			'days' => $daysunsun,
// 			'meals' => $mealnone, 'discountable' => false)
		),
	'Add_Family' => array(
		'Sun - Sun' => array(
			'code' => 'SS-F-FR', 'rate' => 180,
			'notes' => 'Additional Family Full Rate Sun-Sun',
			'days' => $daysunsun,
			'meals' => $mealall, 'discountable' => false),
		'Wed - Sun' => array(
			'code' => 'WS-F-FR', 'rate' => 140,
			'notes' => 'Additional Family Full Rate Wed-Sun',
			'days' => $daywedsun,
			'meals' => $mealall, 'discountable' => false),
		'Fri - Sun' => array(
			'code' => 'FS-F-FR', 'rate' => 110,
			'notes' => 'Additional Family Full Rate Fri-Sun',
			'days' => $dayfrisun,
			'meals' => $mealfrisun, 'discountable' => false),
		'Mon Only' => array(
			'code' => '1M-A-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1mon,
			'notes' => 'Additional Family Monday only',
			'meals' => $mealnone, 'discountable' => false),
		'Tue Only' => array(
			'code' => '1T-A-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1tue,
			'notes' => 'Additional Family Tuesday only',
			'meals' => $mealnone, 'discountable' => false),
		'Wed Only' => array(
			'code' => '1W-A-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1wed,
			'notes' => 'Additional Family Wednesday only',
			'meals' => $mealnone, 'discountable' => false),
		'Thu Only' => array(
			'code' => '1R-A-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1thu,
			'notes' => 'Additional Family Thursday only',
			'meals' => $mealnone, 'discountable' => false),
		'Fri Only' => array(
			'code' => '1F-A-SR',
			'rate' => 115 + $mealnames['meal2']['cost'] + $mealnames['meal3']['cost'],	//	Add Fri meals (meal2 and meal3)
			'days' => $day1fri,
			'notes' => 'Additional Family Friday only',
			'meals' => $mealfrionly, 'discountable' => false),
		'Sat Only' => array(
			'code' => '1A-A-SR',
			'rate' => 136 + $mealnames['meal4']['cost'] + $mealnames['meal5']['cost'],	//	Add Sat meals (meal4 and meal5)
			'days' => $day1sat,
			'notes' => 'Additional Family Saturday only',
			'meals' => $mealsatonly, 'discountable' => false),
// 		'Sun-Sun NO MEALS' => array(
// 			'code' => 'SS-F-SR', 'rate' => 50,
// 			'notes' => 'Additional Family NO MEALS Sun-Sun',
// 			'days' => $daysunsun,
// 			'meals' => $mealnone, 'discountable' => false)
		),
	'Committee_Full' => array(
		'Sun - Sun' => array(
			'code' => 'SS-I-CF', 'rate' => 0,	//	Proposed
			'notes' => 'Committee Rate Full Discount Sun-Sun',
			'days' => $daysunsun,
			'meals' => $mealall, 'discountable' => false),
		'Wed - Sun' => array(
			'code' => 'WS-I-CF', 'rate' => 0,	//	Proposed
			'notes' => 'Committee Rate Full Discount Wed-Sun',
			'days' => $daywedsun,
			'meals' => $mealall, 'discountable' => false),
		'Fri - Sun' => array(
			'code' => 'FS-I-CF', 'rate' => 0,	//	Proposed
			'notes' => 'Committee Rate Full Discount Fri-Sun',
			'days' => $dayfrisun,
			'meals' => $mealall, 'discountable' => false)
		),
	'Committee_Partial' => array(
		'Sun - Sun' => array(
			'code' => 'SS-I-CP', 'rate' => 50,	//	Proposed
			'notes' => 'Committee Rate Partial Discount Sun-Sun',
			'days' => $daysunsun,
			'meals' => $mealall, 'discountable' => false),
		'Wed - Sun' => array(
			'code' => 'WS-I-CP', 'rate' => 50,	//	Proposed
			'notes' => 'Committee Rate Partial Discount Wed-Sun',
			'days' => $daywedsun,
			'meals' => $mealall, 'discountable' => false),
		'Fri - Sun' => array(
			'code' => 'FS-I-CP', 'rate' => 50,	//	Proposed
			'notes' => 'Committee Rate Partial Discount Fri-Sun',
			'days' => $dayfrisun,
			'meals' => $mealall, 'discountable' => false)
		),
	'Resource_Presenter' => array(
		'Selected Days' => array(
			'code' => 'SD-P-FR', 'rate' => 0,
			'notes' => 'Presenter Selected Days',
			'days' => $daynone,	/*	Manually selected during registration */
			'meals' => $mealnone, 
			'mealselectone' => true,
			'discountable' => false)
		),
	'Resource_Vendor' => array(
		'Selected Days' => array(
			'code' => 'SD-V-FR', 'rate' => 35,
			'notes' => 'Vendor Selected Days',
			'days' => $daynone,	/*	Manually selected during registration */
			'meals' => $mealnone, 'discountable' => false)
		),
	'Observer' => array(
		'Selected Days' => array(
			'code' => 'SD-O-FR', 'rate' => 0,
			'notes' => 'Observer Selected Days',
			'days' => $daynone,	/*	Manually selected during registration */
			'meals' => $mealnone,
			'mealselectone' => true,
			'discountable' => false)
		),
	'Guest' => array(
		'Selected Days' => array(
			'code' => 'SD-G-FR', 'rate' => 180,
			'notes' => 'Guest Selected Days',
			'days' => $daynone,	/*	Manually selected during registration */
			'meals' => $mealnone,
			'mealselectone' => true,
			'discountable' => false)
		),
	'Assistant' => array(
		'Selected Days' => array(
			'code' => 'SD-A-FR', 'rate' => 0,
			'notes' => 'Assistant Selected Days',
			'days' => $daynone,	/*	Manually selected during registration */
			'meals' => $mealnone, 'discountable' => false)
		)
);

/*	End of Full Rate base rates. Now see what month we're in to see if we need to redefine the Single rate to a different tier level. */

switch (true) {
case ($check['rate_tier']['1']):	//	Nothing to do, base rate applies
	break;
	
case ($check['rate_tier']['2']):	//	tier 2 rate structure
	$packages['Full Rate']['Single'] = array(
		'Sun - Sun' => array(
			'code' => 'SS-I-FR', 'rate' => 450,
			'notes' => 'Single T2 Full Rate Sun-Sun',
			'days' => $daysunsun,
			'meals' => $mealall, 'discountable' => false),
		'Wed - Sun' => array(
			'code' => 'WS-I-FR', 'rate' => 400,
			'notes' => 'Single T2 Full Rate Wed-Sun',
			'days' => $daywedsun,
			'meals' => $mealall, 'discountable' => false),
		'Fri - Sun' => array(
			'code' => 'FS-I-FR', 'rate' => 330,
			'notes' => 'Single T2 Full Rate Fri-Sun',
			'days' => $dayfrisun,
			'meals' => $mealfrisun, 'discountable' => false),
		'Mon Only' => array(
			'code' => '1M-I-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1mon,
			'notes' => 'Single T2 Monday only',
			'meals' => $mealnone, 'discountable' => false),
		'Tue Only' => array(
			'code' => '1T-I-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1tue,
			'notes' => 'Single T2 Tuesday only',
			'meals' => $mealnone, 'discountable' => false),
		'Wed Only' => array(
			'code' => '1W-I-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1wed,
			'notes' => 'Single T2 Wednesday only',
			'meals' => $mealnone, 'discountable' => false),
		'Thu Only' => array(
			'code' => '1R-I-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1thu,
			'notes' => 'Single T2 Thursday only',
			'meals' => $mealnone, 'discountable' => false),
		'Fri Only' => array(
			'code' => '1F-I-SR',
			'rate' => 115 + $mealnames['meal2']['cost'] + $mealnames['meal3']['cost'],	//	Add Fri meals (meal2 and meal3)
			'days' => $day1fri,
			'notes' => 'Single T2 Friday only',
			'meals' => $mealfrionly, 'discountable' => false),
		'Sat Only' => array(
			'code' => '1A-I-SR',
			'rate' => 136 + $mealnames['meal4']['cost'] + $mealnames['meal5']['cost'],	//	Add Sat meals (meal4 and meal5)
			'days' => $day1sat,
			'notes' => 'Single T2 Saturday only',
			'meals' => $mealsatonly, 'discountable' => false),
// 		'Sun-Sun NO MEALS' => array(
// 			'code' => 'SS-I-SR', 'rate' => 320,
// 			'days' => $daysunsun,
// 			'notes' => 'Single T2 NO MEALS Sun-Sun',
// 			'meals' => $mealnone, 'discountable' => false)
		);
	break;

case ($check['rate_tier']['3']):	//	tier 3 rate structure
	$packages['Full Rate']['Single'] = array(
		'Sun - Sun' => array(
			'code' => 'SS-I-FR', 'rate' => 460,
			'notes' => 'Single T3 Full Rate Sun-Sun',
			'days' => $daysunsun,
			'meals' => $mealall, 'discountable' => false),
		'Wed - Sun' => array(
			'code' => 'WS-I-FR', 'rate' => 410,
			'notes' => 'Single T3 Full Rate Wed-Sun',
			'days' => $daywedsun,
			'meals' => $mealall, 'discountable' => false),
		'Fri - Sun' => array(
			'code' => 'FS-I-FR', 'rate' => 340,
			'notes' => 'Single T3 Full Rate Fri-Sun',
			'days' => $dayfrisun,
			'meals' => $mealfrisun, 'discountable' => false),
		'Mon Only' => array(
			'code' => '1M-I-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1mon,
			'notes' => 'Single T3 Monday only',
			'meals' => $mealnone, 'discountable' => false),
		'Tue Only' => array(
			'code' => '1T-I-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1tue,
			'notes' => 'Single T3 Tuesday only',
			'meals' => $mealnone, 'discountable' => false),
		'Wed Only' => array(
			'code' => '1W-I-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1wed,
			'notes' => 'Single T3 Wednesday only',
			'meals' => $mealnone, 'discountable' => false),
		'Thu Only' => array(
			'code' => '1R-I-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1thu,
			'notes' => 'Single T3 Thursday only',
			'meals' => $mealnone, 'discountable' => false),
		'Fri Only' => array(
			'code' => '1F-I-SR',
			'rate' => 115 + $mealnames['meal2']['cost'] + $mealnames['meal3']['cost'],	//	Add Fri meals (meal2 and meal3)
			'days' => $day1fri,
			'notes' => 'Single T3 Friday only',
			'meals' => $mealfrionly, 'discountable' => false),
		'Sat Only' => array(
			'code' => '1A-I-SR',
			'rate' => 136 + $mealnames['meal4']['cost'] + $mealnames['meal5']['cost'],	//	Add Sat meals (meal4 and meal5)
			'days' => $day1sat,
			'notes' => 'Single T3 Saturday only',
			'meals' => $mealsatonly, 'discountable' => false),
// 		'Sun-Sun NO MEALS' => array(
// 			'code' => 'SS-I-SR', 'rate' => 330,
// 			'days' => $daysunsun,
// 			'notes' => 'Single T3 NO MEALS Sun-Sun',
// 			'meals' => $mealnone, 'discountable' => false)
		);
	break;

case ($check['rate_tier']['4']):	//	tier 4 rate structure
	$packages['Full Rate']['Single'] = array(
		'Sun - Sun' => array(
			'code' => 'SS-I-FR', 'rate' => 470,
			'notes' => 'Single T4 Full Rate Sun-Sun',
			'days' => $daysunsun,
			'meals' => $mealall, 'discountable' => false),
		'Wed - Sun' => array(
			'code' => 'WS-I-FR', 'rate' => 420,
			'notes' => 'Single T4 Full Rate Wed-Sun',
			'days' => $daywedsun,
			'meals' => $mealall, 'discountable' => false),
		'Fri - Sun' => array(
			'code' => 'FS-I-FR', 'rate' => 350,
			'notes' => 'Single T4 Full Rate Fri-Sun',
			'days' => $dayfrisun,
			'meals' => $mealfrisun, 'discountable' => false),
		'Mon Only' => array(
			'code' => '1M-I-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1mon,
			'notes' => 'Single T4 Monday only',
			'meals' => $mealnone, 'discountable' => false),
		'Tue Only' => array(
			'code' => '1T-I-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1tue,
			'notes' => 'Single T4 Tuesday only',
			'meals' => $mealnone, 'discountable' => false),
		'Wed Only' => array(
			'code' => '1W-I-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1wed,
			'notes' => 'Single T4 Wednesday only',
			'meals' => $mealnone, 'discountable' => false),
		'Thu Only' => array(
			'code' => '1R-I-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1thu,
			'notes' => 'Single T4 Thursday only',
			'meals' => $mealnone, 'discountable' => false),
		'Fri Only' => array(
			'code' => '1F-I-SR',
			'rate' => 115 + $mealnames['meal2']['cost'] + $mealnames['meal3']['cost'],	//	Add Fri meals (meal2 and meal3)
			'days' => $day1fri,
			'notes' => 'Single T4 Friday only',
			'meals' => $mealfrionly, 'discountable' => false),
		'Sat Only' => array(
			'code' => '1A-I-SR',
			'rate' => 136 + $mealnames['meal4']['cost'] + $mealnames['meal5']['cost'],	//	Add Sat meals (meal4 and meal5)
			'days' => $day1sat,
			'notes' => 'Single T4 Saturday only',
			'meals' => $mealsatonly, 'discountable' => false),
// 		'Sun-Sun NO MEALS' => array(
// 			'code' => 'SS-I-SR', 'rate' => 340,
// 			'days' => $daysunsun,
// 			'notes' => 'Single T4 NO MEALS Sun-Sun',
// 			'meals' => $mealnone, 'discountable' => false)
		);
	$packages['Full Rate']['Resource_Vendor'] = array(
		//	Increase Vendor late registration fee
		'Selected Days' => array(
			'code' => 'SD-V-FR', 'rate' => 50,
			'notes' => 'Vendor Late Reg Selected Days',
			'days' => $daynone,	//	Manually selected during registration
			'meals' => $mealnone, 'discountable' => false)
		);
/*
	$packages['Full Rate']['Resource_Presenter'] = array(
		//	Increase Presenter late registration fee
		'Selected Days' => array(
			'code' => 'SD-P-FR', 'rate' => 50,
			'notes' => 'Presenter Late Reg Selected Days',
			'days' => $daynone,	//	Manually selected during registration
			'meals' => $mealnone, 'discountable' => false)
		);
*/
	break;
case ($check['rate_tier']['5']):	//	tier 5 rate structure
	$packages['Full Rate']['Single'] = array(
		'Sun - Sun' => array(
			'code' => 'SS-I-FR', 'rate' => 480,
			'notes' => 'Single T5 Full Rate Sun-Sun',
			'days' => $daysunsun,
			'meals' => $mealall, 'discountable' => false),
		'Wed - Sun' => array(
			'code' => 'WS-I-FR', 'rate' => 430,
			'notes' => 'Single T5 Full Rate Wed-Sun',
			'days' => $daywedsun,
			'meals' => $mealall, 'discountable' => false),
		'Fri - Sun' => array(
			'code' => 'FS-I-FR', 'rate' => 360,
			'notes' => 'Single T5 Full Rate Fri-Sun',
			'days' => $dayfrisun,
			'meals' => $mealfrisun, 'discountable' => false),
		'Mon Only' => array(
			'code' => '1M-I-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1mon,
			'notes' => 'Single T5 Monday only',
			'meals' => $mealnone, 'discountable' => false),
		'Tue Only' => array(
			'code' => '1T-I-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1tue,
			'notes' => 'Single T5 Tuesday only',
			'meals' => $mealnone, 'discountable' => false),
		'Wed Only' => array(
			'code' => '1W-I-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1wed,
			'notes' => 'Single T5 Wednesday only',
			'meals' => $mealnone, 'discountable' => false),
		'Thu Only' => array(
			'code' => '1R-I-SR',
			'rate' => 75,	//	flat rate
			'days' => $day1thu,
			'notes' => 'Single T5 Thursday only',
			'meals' => $mealnone, 'discountable' => false),
		'Fri Only' => array(
			'code' => '1F-I-SR',
			'rate' => 115 + $mealnames['meal2']['cost'] + $mealnames['meal3']['cost'],	//	Add Fri meals (meal2 and meal3)
			'days' => $day1fri,
			'notes' => 'Single T5 Friday only',
			'meals' => $mealfrionly, 'discountable' => false),
		'Sat Only' => array(
			'code' => '1A-I-SR',
			'rate' => 136 + $mealnames['meal4']['cost'] + $mealnames['meal5']['cost'],	//	Add Sat meals (meal4 and meal5)
			'days' => $day1sat,
			'notes' => 'Single T5 Saturday only',
			'meals' => $mealsatonly, 'discountable' => false),
// 		'Sun-Sun NO MEALS' => array(
// 			'code' => 'SS-I-SR', 'rate' => 350,
// 			'days' => $daysunsun,
// 			'notes' => 'Single T5 NO MEALS Sun-Sun',
// 			'meals' => $mealnone, 'discountable' => false)
		);
	$packages['Full Rate']['Resource_Vendor'] = array(
		//	Increase vendor late registration fee
		'Selected Days' => array(
			'code' => 'SD-V-FR', 'rate' => 50,
			'notes' => 'Vendor Late Reg Selected Days',
			'days' => $daynone,	/*	Manually selected during registration */
			'meals' => $mealnone, 'discountable' => false)
		);
/*
	$packages['Full Rate']['Resource_Presenter'] = array(
		//	Increase Presenter late registration fee
		'Selected Days' => array(
			'code' => 'SD-P-FR', 'rate' => 50,
			'notes' => 'Presenter Late Reg Selected Days',
			'days' => $daynone,	//	Manually selected during registration
			'meals' => $mealnone, 'discountable' => false)
		);
*/
	break;
default:
	break;
}

/*	Onsite Rates for Thursday arrival (same as Full Rate walk-in - i.e., highest
	tier - but no Sun-Sun rate, no meals Friday and no NO MEALS option). All set
	at tier 5 (maximum charge) */

$packages['Onsite Thursday']['Single'] = array(
/*	'Sun - Sun' => array(
		'code' => 'SS-I-FR', 'rate' => 480,
		'notes' => 'Single Thu arrival',
		'days' => $daythusun,
		'meals' => array(0,0,0,1,1,1), 'discountable' => false), */
	'Wed - Sun' => array(
		'code' => 'WS-I-FR', 'rate' => 430,
		'notes' => 'Single Thu arrival',
		'days' => $daythusun,
		'meals' => array(0,0,0,1,1,1), 'discountable' => false),
	'Fri - Sun' => array(
		'code' => 'FS-I-FR', 'rate' => 360,
		'notes' => 'Single Thu arrival',
		'days' => $daythusun,
		'meals' => array(0,0,0,1,1,1), 'discountable' => false)
);
$packages['Onsite Thursday']['SO'] = array(
/*	'Sun - Sun' => array(
		'code' => 'SS-S-FR', 'rate' => 280,
		'notes' => 'SO Thu arrival',
		'days' => $daythusun,
		'meals' => array(0,0,0,1,1,1), 'discountable' => false), */
	'Wed - Sun' => array(
		'code' => 'WS-S-FR', 'rate' => 240,
		'notes' => 'SO Thu arrival',
		'days' => $daythusun,
		'meals' => array(0,0,0,1,1,1), 'discountable' => false),
	'Fri - Sun' => array(
		'code' => 'FS-S-FR', 'rate' => 210,
		'notes' => 'SO Thu arrival',
		'days' => $daythusun,
		'meals' => array(0,0,0,1,1,1), 'discountable' => false)
);
$packages['Onsite Thursday']['Add_Family'] = array(
/*	'Sun - Sun' => array(
		'code' => 'SS-F-FR', 'rate' => 130,
		'notes' => 'Additional Family Thu Arrival',
		'days' => $daythusun,
		'meals' => array(0,0,0,1,1,1), 'discountable' => false), */
	'Wed - Sun' => array(
		'code' => 'WS-F-FR', 'rate' => 120,
		'notes' => 'Additional Family Thu Arrival',
		'days' => $daythusun,
		'meals' => array(0,0,0,1,1,1), 'discountable' => false),
	'Fri - Sun' => array(
		'code' => 'FS-F-FR', 'rate' => 80,
		'notes' => 'Additional Family Thu Arrival',
		'days' => $daythusun,
		'meals' => array(0,0,0,1,1,1), 'discountable' => false)
);
$packages['Onsite Thursday']['Committee_Full'] = array(
/*		'Sun - Sun' => array(
		'code' => 'SS-I-CF', 'rate' => 0,
		'notes' => 'Committee Rate Full Discount Thu Arrival Sun-Sun',
		'days' => $daythusun,
		'meals' => $mealall, 'discountable' => false), */
	'Wed - Sun' => array(
		'code' => 'WS-I-CF', 'rate' => 0,
		'notes' => 'Committee Rate Full Discount Thu Arrival Wed-Sun',
		'days' => $daythusun,
		'meals' => $mealall, 'discountable' => false),
	'Fri - Sun' => array(
		'code' => 'FS-I-CF', 'rate' => 0,
		'notes' => 'Committee Rate Full Discount Thu Arrival Fri-Sun',
		'days' => $daythusun,
		'meals' => $mealall, 'discountable' => false)
);
$packages['Onsite Thursday']['Committee_Partial'] = array(
/*		'Sun - Sun' => array(
		'code' => 'SS-I-CP', 'rate' => 50,
		'notes' => 'Committee Rate Partial Discount Thu Arrival Sun-Sun',
		'days' => $daythusun,
		'meals' => $mealall, 'discountable' => false), */
	'Wed - Sun' => array(
		'code' => 'WS-I-CP', 'rate' => 50,
		'notes' => 'Committee Rate Partial Discount Thu Arrival Wed-Sun',
		'days' => $daythusun,
		'meals' => $mealall, 'discountable' => false),
	'Fri - Sun' => array(
		'code' => 'FS-I-CP', 'rate' => 50,
		'notes' => 'Committee Rate Partial Discount Thu Arrival Fri-Sun',
		'days' => $daythusun,
		'meals' => $mealall, 'discountable' => false)
);
$packages['Onsite Thursday']['Observer'] = array(
	'Selected Days' => array(
		'code' => 'SD-O-FR', 'rate' => 0,
		'notes' => 'Observer Thu Arrival Selected Days',
		'days' => $daynone,
		'meals' => $mealall, 'discountable' => false)
);
$packages['Onsite Thursday']['Guest'] = array(
	'Selected Days' => array(
		'code' => 'SD-G-FR', 'rate' => 40,
		'notes' => 'Guest Thu Arrival Selected Days',
		'days' => $daynone,
		'meals' => $mealnone, 'discountable' => false)
);
$packages['Onsite Thursday']['Resource_Vendor'] = array(
	'Selected Days' => array(
		'code' => 'SD-V-FR', 'rate' => 25,
		'notes' => 'Vendor Thu Arrival Selected Days',
		'days' => $daynone,
		'meals' => $mealnone, 'discountable' => false)
);

/* End of Onsite Thursday rates */

/*	Onsite Rates for Friday arrival (same as Full Rate but no Sun-Sun or Wed-Sun
	rate and no meals Friday or Saturday). All set at tier 4 (maximum charge) */

$packages['Onsite Friday']['Single'] = array(
	'Fri - Sun' => array(
		'code' => 'FS-I-FR', 'rate' => 360,
		'notes' => 'Single Fri arrival',
		'days' => $daythusun,
		'meals' => array(0,0,0,0,1,1), 'discountable' => false)
);
$packages['Onsite Friday']['SO'] = array(
	'Fri - Sun' => array(
		'code' => 'FS-S-FR', 'rate' => 210,
		'notes' => 'SO Full Rate Fri Arrival Fri-Sun',
		'days' => $dayfrisun,
		'meals' => array(0,0,0,0,1,1), 'discountable' => false)
);
$packages['Onsite Friday']['Add_Family'] = array(
	'Fri - Sun' => array(
		'code' => 'FS-F-FR', 'rate' => 80,
		'notes' => 'Fri Arrival',
		'days' => $dayfrisun,
		'meals' => array(0,0,0,0,1,1), 'discountable' => false)
);
$packages['Onsite Friday']['Committee_Full'] = array(
	'Fri - Sun' => array(
		'code' => 'FS-I-CF', 'rate' => 100,
		'notes' => 'Committee Rate Full Discount Fri Arrival',
		'days' => $dayfrisun,
		'meals' => $mealall, 'discountable' => false)
);
$packages['Onsite Friday']['Committee_Partial'] = array(
	'Fri - Sun' => array(
		'code' => 'FS-I-CP', 'rate' => 150,
		'notes' => 'Committee Rate Partial Discount Fri Arrival',
		'days' => $dayfrisun,
		'meals' => $mealall, 'discountable' => false)
);
$packages['Onsite Friday']['Observer'] = array(
	'Fri - Sun' => array(
		'code' => 'FS-O-FR', 'rate' => 0,
		'notes' => 'Observer FR Fri Arrival',
		'days' => $dayfrisun,
		'meals' => $mealnone, 'discountable' => false)
);
$packages['Onsite Friday']['Guest'] = array(
	'Fri - Sun' => array(
		'code' => 'FS-G-FR', 'rate' => 50,
		'notes' => 'Guest FR Fri Arrival Fri-Sun',
		'days' => $dayfrisun,
		'meals' => $mealnone, 'discountable' => false)
);
$packages['Onsite Friday']['Resource_Vendor'] = array(
	'Fri - Sun' => array(
		'code' => 'FS-V-FR', 'rate' => 25,
		'notes' => 'Vendor FR Fri Arrival',
		'days' => $dayfrisun,
		'meals' => $mealnone, 'discountable' => false)
);

/*	End of Onsite Friday rates */

/*	Define which package is presently in effect depending on the date.
	Forms and other pages referring to config.php should use $package to get the
	correct set of rates, not try to parse the dates themselves. */

global $package;

if ($check['onsite_registration_open_friday']) {
	$package['Onsite Friday'] = $packages['Onsite Friday'];
}
elseif ($check['onsite_registration_open_thursday']) {
	$package['Onsite Thursday'] = $packages['Onsite Thursday'];
}
elseif ($check['committee_preregistration_open']
		or $check['presenter_preregistration_open']
		or $check['vendor_preregistration_open']) {
	$package['Full Rate'] = $packages['Full Rate'];
}
elseif ($check['registration_open']) {
	$package['Full Rate'] = $packages['Full Rate'];
}

	
/*	PayPal account */
/*	If TESTING is set, use developer's (Stephanie Mitchell's) sandbox account,
	otherwise use the main Esprit account. */

global $paypal_account, $paypal_site, $paypal_callback;
$paypal_account = (TESTING) ? 'stephanie-facilitator@cornbury.org' : 'registrar@espritconf.com';
$paypal_site = (TESTING) ? 'www.sandbox.paypal.com' : 'www.paypal.com';
$paypal_callback = (TESTING) ? 'ipnpb.sandbox.paypal.com/cgi-bin/webscr' : 'ipnpb.paypal.com/cgi-bin/webscr';



/*
	Define some boilerplate legalese that is included on every form.
	It's much easier to keep it consistent this way.
*/

global $tos_acknowlegement;
$tos_acknowlegement = "<span class=\"bold\">By submitting this registration application I acknowledge that I have read the following terms and agree to them and will comply with them.</span>";

global $conduct_text;
$conduct_text = "<span class=\"i\">Esprit</span> is an event for transgender people to meet, learn and socialize in an atmosphere of mutual respect and consent within the convention, the hotel, its staff and guests, and the community at large. Respectable and respectful attire and behaviour is expected regardless of your choice of gender presentation.

Esprit is a private event and occurs on private property, in a public setting, and both the hotel's and Esprit's rules of conduct apply. Lewd, lascivious, offensive, intrusive or fetish behavior by attendees or visitors, determined solely at Esprit's discretion, will not be tolerated and Esprit reserves the right to refuse admission or cancel the remaining portion of an attendee's participation if this code is violated.";


global $sig_intro;
$sig_intro = "The statement below will appear on the official confirmation letter you will receive. You must sign that letter with your legal name indicating your acceptance of it. Your legal name and signature will not be stored or used for any other purpose.";

global $sig_agreement;
$sig_agreement = "I agree to abide by the <span class=\"i\">Esprit</span> Rules of Conduct and attest to the fact that I will be at least 21 years of age upon arrival at <span class=\"i\">Esprit, unless attending as a child of an attendee</span>. If a couple, I attest that we are a couple in a legally recognized relationship or who have been living together (maintaining the same physical residence) continuously for the past 12 months.";

global $refund_policy;
$refund_policy = "Refunds will be made only upon written request. Requests postmarked on or before {$date_text['refund_full_deadline']} are eligible for a full refund. Requests postmarked between {$date_text['refund_full_closed']} and {$date_text['refund_50_deadline']} inclusive are eligible for a 50% refund. No refunds if postmarked on or after {$date_text['refund_50_closed']}. Extenuating circumstances will be considered at Esprit's sole discretion.";

/*
	Mailing address for registrations - may change from year to year.
	Note: two versions: HTML and plain text.
*/

global $esprit_address, $esprit_address_text;
$esprit_address = 'NOTE - NEW ADDRESS! Esprit Registrar, PO BOX 1986, ISSAQUAH WA 98027-0085';
$esprit_address_text = 'NOTE - NEW ADDRESS!\nEsprit Registrar\nPO BOX 1986\nISSAQUAH WA 98027-0085\n';

/*
	Some directories, defined here for consistency and conciseness.
*/

$GLOBALS['badgephotodir'] = "{$_SERVER['DOCUMENT_ROOT']}/.data/badgephotos/$esprit_year/";
$GLOBALS['badgephotouri'] = "/.data/badgephotos/$esprit_year/";
$GLOBALS['badgephotourl'] = "{$_SERVER['REQUEST_SCHEME']}://{$_SERVER['HTTP_HOST']}{$GLOBALS['badgephotouri']}";

$GLOBALS['qrcodedir'] = "{$_SERVER['DOCUMENT_ROOT']}/.data/qrcode/attendee/$esprit_year/";
$GLOBALS['qrcodeuri'] = "/.data/qrcode/attendee/$esprit_year/";
$GLOBALS['qrcodeurl'] = "{$_SERVER['REQUEST_SCHEME']}://{$_SERVER['HTTP_HOST']}{$GLOBALS['qrcodeuri']}";

$GLOBALS['badgeicondir'] = "{$_SERVER['DOCUMENT_ROOT']}/../lib/badgeicons/";
$GLOBALS['badgeiconuri'] = "/../lib/badgeicons/";
$GLOBALS['badgeiconurl'] = "{$_SERVER['REQUEST_SCHEME']}://{$_SERVER['HTTP_HOST']}{$GLOBALS['badgeiconuri']}";

$GLOBALS['pixdir'] = "{$_SERVER['DOCUMENT_ROOT']}/manager/pix/";
$GLOBALS['pixuri'] = "/manager/pix/";
$GLOBALS['pixurl'] = "{$_SERVER['REQUEST_SCHEME']}://{$_SERVER['HTTP_HOST']}{$GLOBALS['pixuri']}";

?>
