<?php
/*
	Esprit Registration System
	by Stephanie Mitchell, 16 April, 2019
	
	This file sets up important constants for the entire Registration and
	Scholarship Application system. It is also used by the stats charting
	package for setting the current Esprit year.
	
	Set up deadlines and cutoffs.
*/

/*
	TESTING switch. Set to true while debugging. Suppresses emails to Esprit
	Registrar and allows you to enter an arbitrary date in the registration URL,
	among other things.
*/
define('TESTING', true);		
/*
	SHOW_ERRORS switch. Controls error reporting. Must be false during
	production but may be set to true while debugging and developing.
	
	WARNING - setting this to true can cause perfectly innocent error messages
	to produce bogus field values which then cause database update failures. If
	you start getting unexplained MySQL failures, try setting SHOW_ERRORS to
	false.
*/
define('SHOW_ERRORS', true);
/*
	PHPMailer debug output level. From the docs:
	* Options:
	* * `0` No output
	* * `1` Commands
	* * `2` Data and commands
	* * `3` As 2 plus connection status
	* * `4` Low-level data output
	
	NOTE - this only affects emails from the backend system; no debugging info
	is ever sent to the front-end (public-facing) pages.
*/
define('MAIL_DEBUG_LEVEL', 0);

if (SHOW_ERRORS and TESTING) {	//	Never show errors in production mode
	ini_set('display_startup_errors',1);
	ini_set('display_errors',1);
	error_reporting(-1);		//	All errors
} else {
	ini_set('display_startup_errors',0);
	ini_set('display_errors',0);
	error_reporting(0);			//	No errors
}

/*	Timezone */
define('TIMEZONE', 'America/Los_Angeles');
ini_set('date.timezone', TIMEZONE);

define('_LOGFILENAME', 'reglog'); 				//	Main log file name
define('_EMAIL_LOGFILENAME', 'regemaillog'); 	//	Email log file name
define('_DBNAME', 'esprit');					//	Database name

/*	Protect from non-logged in users */

defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');

$GLOBALS['esprit_year'] = 2019;				//	4-digit year of the Esprit being
											//	processed
$esprit_year = $GLOBALS['esprit_year'];		//	For convenience in further
											//	definitions below

/*
	$esprit_week_shift accounts for when the dates of Esprit shift by a week
	within the month. It's normally zero, but needs to be set to 1 when the date
	of Esprit moves forward a week. This is significant when cloning events from
	one year to the next. Cloning an event means recalculating its dates to land
	on the same relative weekday - but it must take into account the one-week
	shift in such cases. For example, in 2016 Esprit began on 8 May. in 2017 it
	began on 14 May (not 7 May), so $esprit_week_shift must be set to 1.
*/

$GLOBALS['esprit_week_shift'] = 0;	//	Going from 2018 (May 13) to 2019 (May 12)

$GLOBALS['regsystemversion'] = 'Esprit Registration System Version 2.2 BETA';

/*
	Package date override. Set in URL; if set to "PKO" (all caps), returns
	package rates for date specified in URL instead of actual date, irrespective
	of value of TESTING.
*/
$GLOBALS['pko'] = (isset($_REQUEST['pko']) ? $_REQUEST['pko'] == 'PKO' : false);

global $today_text, $today, $test_msg, $auto_login_ids;

if (TESTING or $pko) {	//	If we're testing, we can specify ?date=yyyy-mm-dd in
						//	the URL to check the logic for different dates
	$today_text = (isset($_REQUEST['date']) ? $_REQUEST['date'] : 'now');
	$test_msg = 'TEST';
} else {
 	$today_text = 'now';
 	$test_msg = '';
}
$today = strtotime($today_text);
//	print 'Today: '.strftime('%F %T %Z', $today).'<br />';	//	uncomment for testing
$today_text = strftime('%B %e, %Y', $today);	//	fix for printing

/*
	These unlock/override keys are generated using MD5. The actual source phrase
	is unimportant. Only these 32-character strings are distributed.
*/
/*	Unlocks Scholarship dates */
$GLOBALS['scholarship_override'] = '1f4e4686b1667ca0a0e14d7438683c79';
/*	Unlocks special reg forms */
$GLOBALS['committee_override'] = '59bd09b61e79c9e74874e7e2e0b67ff5';
/*	Unlocks presenter forms - will also unlock Assistant form */
$GLOBALS['presenter_override'] = 'bcfbdd192823332945ab2526ea82fc76';
/*	Unlocks vendor forms - will also unlock Assistant form */
$GLOBALS['vendor_override'] = '6e139402e92adc23f70e7f373526559d';

/*
	Pronoun options. These appear as a selection on the registration form and on
	badges.
	NOTE: For some reason, using this in fieldlist.php files as allowedvalues
	for menus doesn't seem to work, so if you change this you must also change
	the corresponding values in attendees/fieldlist.php.
*/
$GLOBALS['pronouns'] = ['-', 'She, Her', 'He, Him', 'They, Them', 'Ze, Zir'];
/*
	Important dates for Esprit.
	
	Keep the following dates in this order, ascending, for consistency.
	
	Make sure you enter the dates in a pleasingly human-readable format such as
	that shown, as they are included as-is in many forms and emails.
	
	Dates that have "deadline" in their name will automatically have "23:59"
	appended to them so that the actual deadline time is at the end of that day,
	not the beginning. However the 23:59 doesn't print as part of the date text.
*/

/*	Registration cap for Esprit. Maximum number of registrations we can accept.
	Currently there is NO CODE TO ENFORCE THIS. */
	
$GLOBALS['esprit_cap'] = 150;

global $date_text;

/*
	Start and end dates for Esprit
*/
$date_text['esprit_start'] = 'May 12th, 2019';		//	first Sunday of Esprit
$date_text['esprit_end'] = 'May 19th, 2019';		//	last Sunday of Esprit

/*
	Registration dates
*/
$date_text['registration_open'] = 'January 1st, 2019';	//	usually January 1
$date_text['registration_deadline'] = 'May 18th, 2019';	//	last Sat of Esprit
$date_text['registration_closed'] = 'May 19th, 2019';	//	day after above
														//	= esprit_end
$date_text['payment_deadline'] = 'April 26th, 2019';	//	Friday 2 wk before
														//	Esprit

/*
	Vendor and Presenter Special registration dates. These allow vendors and
	presenters to register before the rest of the world.
	xxx_open date is usually 2 months before registration_open, i.e. typically
	November 1 of the preceding year.
	xxx_deadline is the Friday of precon (usually first weekend in April,
	barring conflicts with Easter)
*/
$date_text['vendor_registration_open'] = 'November 1st, 2018';
$date_text['vendor_registration_deadline'] = 'April 14th, 2019';
$date_text['presenter_registration_open'] = 'November 1st, 2018';
$date_text['presenter_registration_deadline'] = 'April 14th, 2019';

/*
	Committee Special registration date. This allows Committee members to
	register before the rest of the world. Typically 2 months before
	registration_open (i.e. November 1).
*/
$date_text['committee_registration_open'] = 'November 1st, 2018';

/*	
	Onsite registration date. Matches esprit_start.
*/
$date_text['onsite_registration_open'] = $date_text['esprit_start'];;

/*
	Next two entries are for meal package calculations for late walk-ins. Set to
	last Thursday and Friday of Esprit.
*/
$date_text['onsite_registration_open_thursday'] = 'May 16th, 2019';
$date_text['onsite_registration_open_friday'] = 'May 17th, 2019';

/*
	Registration closed date. Matches esprit_end.
*/
$date_text['onsite_registration_closed'] = $date_text['esprit_end'];

/*
	Tiered rate structure dates. These determine what tier to charge people at
	any given time. There must be exactly 5. The first one must match
	registration_open and the last one must match esprit_start. The middle three
	are usually one month apart in ascending order, indicating the date at which
	that tier pricing starts. Any dates can be set; the code does not require
	month boundaries.

	IF YOU CHANGE THE NUMBER OF TIERS, there are a number of changes you'll have
	to make. You'll have to edit the $check['tier_xx'] code below as well as add
	the relevant entries to the ratepackages database table.
*/
$date_text['tier1'] = $date_text['registration_open'];	//	DO NOT CHANGE
$date_text['tier2'] = 'February 1st, 2019';			//	usually one month window
$date_text['tier3'] = 'March 1st, 2019';			//	usually one month window
$date_text['tier4'] = 'April 1st, 2019';			//	usually one month window
$date_text['tier5'] = 'May 1, 2019';		//	DO NOT CHANGE
//	$date_text['tier5'] = $date_text['esprit_start'];	//	TENTATIVE NEW TIER

/*
	Refund dates. These currently only control messages and content in
	registration form and emails; they don't enforce refund rates in any way.
*/
$date_text['refund_full_deadline'] = 'March 15th, 2019';	//	Friday nearest 15 March
$date_text['refund_full_closed'] = 'March 16th, 2019';		//	day after above
$date_text['refund_50_deadline'] = 'April 12th, 2019';		//	Friday before 15 April
$date_text['refund_50_closed'] = 'April 13th, 2019';		//	day after above

/*
	Scholarship dates. These control open and close dates for scholarship applications. The scholarships_deadline is normally the last day of March but has been extended for 2019.
*/
$date_text['scholarships_open'] = $date_text['registration_open'];
$date_text['scholarships_deadline'] = 'April 12th, 2019';
$date_text['scholarships_closed'] = 'April 13th, 2019';		//	day after above
/*
	Evaluation dates. Not used except to display in calendar and some form
	content.
*/
$date_text['evaluations_open'] = 'May 15th, 2019';		//	4 days before Esprit ends
$date_text['evaluations_closed'] = 'July 31st, 2019';	//	end of July following Esprit

/*
	Veterans' Breakfast (now held only in odd-numbered years, if at all). Set
	this to true to enable ratetable.php to ask applicants if they want to
	attend, false to omit that code and set the meal count to 0. Also affects
	various reports and things on the back end.
*/
$GLOBALS['meal1enabled'] = false;	//	Veterans' Breakfast is meal no 1.

global $date;

/*
	Parse all date strings defined above into actual dates so we can do math on
	them. If the date's name includes "deadline", append 23:59 to the date while
	parsing.
*/
foreach ($date_text as $k => $d) {
	if (strpos($k, 'deadline')>0) {
		$d .=' 23:59';
	}
	$date[$k] = strtotime($d);
//		print "$k: ".strftime('%F %T %Z', $date[$k]).'<br />';	//	uncomment for testing
}

$GLOBALS['esprit_start'] = strftime('%F', $date['esprit_start']);	//	yyyy/mm/dd, used in some reports
$GLOBALS['esprit_end'] = strftime('%F', $date['esprit_end']);	//	yyyy/mm/dd, used in some reports
$GLOBALS['esprit_yy'] = substr($GLOBALS['esprit_year'], 2, 2);	//	2-digit year, used in various places

/*
	Set up a bunch of flags that will simplify date checking elsewhere in the system.
*/
$check = [];
global $check;

/*
	Set a couple of variables to null if they're not already set, to get rid of
	warning messages.
*/

if (!isset($_REQUEST['override'])) { $_REQUEST['override'] = '';}
$check['registration_not_yet_open'] = ($today < $date['registration_open']);
$check['preregistration_open'] = (($today >= $date['registration_open'])
	and ($today <= $date['registration_deadline']));
$check['vendor_preregistration_open'] = (($today >= $date['vendor_registration_open'])
	and ($today <= $date['vendor_registration_deadline'])
	or ($_REQUEST['override'] == $GLOBALS['vendor_override']));
$check['vendor_registration_not_yet_open'] = ($today < $date['vendor_registration_open']);
$check['presenter_preregistration_open'] = (($today >=
		$date['presenter_registration_open'])
	and ($today <= $date['presenter_registration_deadline'])
	or ($_REQUEST['override'] == $GLOBALS['presenter_override']));
$check['presenter_registration_not_yet_open'] = ($today < $date['presenter_registration_open']);
$check['committee_preregistration_open'] = (($today >= 
		$date['committee_registration_open'])
	and ($today <= $date['registration_deadline']));
$check['committee_registration_not_yet_open'] = ($today <	
		$date['committee_registration_open']);
$check['assistant_registration_open'] = ($check['presenter_preregistration_open'] or $check['vendor_preregistration_open']);
$check['preregistration_closed'] = ($today > $date['registration_deadline']);
$check['onsite_registration_open'] = (($today >= $date['onsite_registration_open'])
	and ($today < $date['onsite_registration_closed']));
$check['onsite_registration_closed'] = ($today > $date['onsite_registration_closed']);
$check['onsite_registration_open_thursday'] = (($today >= $date['onsite_registration_open_thursday'])
	and ($today < $date['onsite_registration_closed']));
$check['onsite_registration_open_friday'] = (($today >= $date['onsite_registration_open_friday'])
	and ($today < $date['onsite_registration_closed']));
$check['incentive_available'] = false;
$check['scholarships_not_yet_open'] = ($today < $date['scholarships_open']);
$check['scholarships_open'] = (($today >= $date['scholarships_open'])
	and ($today <= $date['scholarships_deadline'])
	or ($_REQUEST['override'] == $GLOBALS['scholarship_override']));
$check['scholarships_closed'] = ($today > $date['scholarships_deadline']);
$check['evaluations_not_yet_open'] = ($today < $date['evaluations_open']);
$check['evaluations_open'] = (($today >= $date['evaluations_open'])
	and ($today < $date['evaluations_closed']));
$check['evaluations_closed'] = ($today > $date['evaluations_closed']);
$check['registration_open'] = ($check['preregistration_open']
	or $check['onsite_registration_open']);
$check['payment_deadline'] = ($today >= $date['payment_deadline']);
$check['refund_full'] = ($check['preregistration_open']
	and ($today <= $date['refund_full_deadline']));
$check['refund_50'] = ($check['preregistration_open']
	and ($today <= $date['refund_50_deadline'])
	and ($today > $date['refund_full_deadline']));
$check['refund_none'] = ($check['preregistration_open']
	and ($today > $date['refund_50_deadline']));
/*
	Tiered rate structure checks. Note that ['rate_tier']['1'] does not check
	against tier1; this is because certain registration categories open before
	regular registration and need to be accommodated.
	
	IF YOU CHANGE THE NUMBER OF TIERS (above), you'll need to adjust the
	following entries to match. You'll also need to make the corresponding
	changes to the regpackages table.
*/

$check['rate_tier'] = [
	'1' => ($today < $date['tier2']),
	'2' => ($today >= $date['tier2']) and ($today < $date['tier3']),
	'3' => ($today >= $date['tier3']) and ($today < $date['tier4']),
	'4' => ($today >= $date['tier4']) and ($today < $date['tier5']),
	'5' => ($today >= $date['tier5']) and ($today < $date['esprit_end'])
];
/*	History book discount availiability */
$check['hist_book_available'] = false; //($today <= $date['hist_book_deadlne']);

/*
	Set up scholarship prorate parameters.
*/
//	Factor an applicant is docked for multiple awards
$GLOBALS['schol_percent_dock'] = 0.25;
//	Maximum factor an applicant can be docked
$GLOBALS['schol_max_dock'] = 1;
//	Maximum awards an applicant can ever receive. 0 means no limit.
$GLOBALS['schol_max_award_count'] = 0;

/*
	Day names for conciseness. Eight-element arrays representing Sunday-Sunday.
*/
$GLOBALS['daynames'] = [
	'daysun1' => ['long' => 'Sunday 1', 'short' => 'Sun1', 'abbr' => 'S1'],
	'daymon' => ['long' => 'Monday', 'short' => 'Mon', 'abbr' => 'Mo'],
	'daytue' => ['long' => 'Tuesday', 'short' => 'Tue', 'abbr' => 'Tu'],
	'daywed' => ['long' => 'Wednesday', 'short' => 'Wed', 'abbr' => 'We'],
	'daythu' => ['long' => 'Thursday', 'short' => 'Thu', 'abbr' => 'Th'],
	'dayfri' => ['long' => 'Friday', 'short' => 'Fri', 'abbr' => 'Fr'],
	'daysat' => ['long' => 'Saturday', 'short' => 'Sat', 'abbr' => 'Sa'],
	'daysun2' => ['long' => 'Sunday 2', 'short' => 'Sun2', 'abbr' => 'S2']
];

/*
	Set up meal names. Saves hard-coding them everywhere.
*/
$GLOBALS['mealnames'] = [
	/*
		meal1 is the Veterans' Breakfast on Friday morning, offered for a few
		years but now discontinued. References to it elsewhere in the code have
		either been removed or commented out.
	*/
	'meal1' => [
		'verbose' =>'Friday Veterans\' Breakfast',
		'long' => 'Veterans\' Breakfast',
		'abbr' => 'Fri. Breakfast',
		'enabled' => $GLOBALS['meal1enabled'],	//	Set above; true only if meal
												//	is offered this year
		'cost' => 21],
	'meal2' => [
		'verbose' =>'Friday Lunch and Fashion Show',
		'long' => 'Friday Lunch',
		'abbr' => 'Fri. Lunch',
		'enabled' => true,
		'cost' => 23],
	'meal3' => [
		'verbose' =>'Friday Dinner and Talent Night',
		'long' => 'Friday Dinner',
		'abbr' => 'Fri. Dinner',
		'enabled' => true,
		'cost' => 43],
	'meal4' => [
		'verbose' =>'Saturday Lunch and Keynote',
		'long' => 'Saturday Lunch',
		'abbr' => 'Sat. Lunch',
		'enabled' => true,
		'cost' => 22],
	'meal5' => [
		'verbose' =>'Saturday Dinner and Gala',
		'long' => 'Saturday Dinner',
		'abbr' => 'Sat. Dinner',
		'enabled' => true,
		'cost' => 45],
	'meal6' => [
		'verbose' => 'Sunday Farewell Brunch',
		'long' => 'Sunday Brunch',
		'abbr' => 'Sun. Brunch',
		'enabled' => true,
		'cost' => 22]
	];

/*
	Set up special meal request options. These are included in the registration
	forms as checkboxes. This is jut a convenient place to store them.
	
	NOTE - since these are displayed in the registration forms for attendees to
	select from, DON'T EDIT THESE without consulting with the committee and with
	the Hotel to confirm what options they can actually offer.
*/
$GLOBALS['specialmealrequests'] = ['Vegetarian', 'Gluten_Free'];

/*
	Rate packages are now implemented in the regpackages database table. Check
	.config2018bkup.php for the original code.
*/

global $packages;	//	Saves a gazillion includes everywhere

/*
	Mail alias table. In 2018 all email addresses of the form
	recipient@espritconf.com were decommissioned, so this table matches up the
	old espritconf.com addresses with their actual recipients. Always enter the
	following in lowercase. Addresses to be compared wth them will be lowercased first.
*/
$GLOBALS['mail_aliases'] = [

	//	Development and test
	'developer@espritconf.com' => 'stephanie@cornbury.org',
	'test@espritconf.com' => 'webmiss@cornbury.org',

	//	Production addresses.
	'registrar@espritconf.com' => 'espritregistrar@telus.net',
	'registrar2@espritconf.com' => 'ms.alyssalee@comcast.net',
	'socoord@espritconf.com' => 'thumpermama@hotmail.com',
	'bigsis@espritconf.com' => 'ms.alyssalee@comcast.net',
	'presenters@espritconf.com' => 'cindi.lane.berry@gmail.com',
	'resources@espritconf.com' => 't_margo@yahoo.com',
	'volunteers@espritconf.com' => 'janjffrs@yahoo.com',
	'yearbook@espritconf.com' => 'stephanie@cornbury.org',
	'badgephoto@espritconf.com' => 'stephanie@cornbury.org',
	'scholarships@espritconf.com' => 'stephanie@cornbury.org'
];

/*	PayPal account */
/*	If TESTING is set, use developer's (Stephanie Mitchell's) sandbox account,
	otherwise use the main Esprit account. */
$GLOBALS['paypal_account'] = (TESTING) ? 'stephanie-facilitator@cornbury.org' : 'registrar@espritconf.com';
$GLOBALS['paypal_site'] = (TESTING) ? 'www.sandbox.paypal.com' : 'www.paypal.com';
$GLOBALS['paypal_callback'] = (TESTING) ? 'ipnpb.sandbox.paypal.com/cgi-bin/webscr' : 'ipnpb.paypal.com/cgi-bin/webscr';

/*
	Define some boilerplate legalese that is included on every form. It's much
	easier to keep it consistent this way.
*/

$GLOBALS['tos_acknowledgement'] = "<span class=\"bold\">By submitting this registration application I acknowledge that I have read the following terms and agree to them and will comply with them.</span>";

$GLOBALS['conduct_text'] = "<span class=\"i\">Esprit</span> is an event for transgender people to meet, learn and socialize in an atmosphere of mutual respect and consent within the convention, the hotel, its staff and guests, and the community at large. Respectable and respectful attire and behaviour is expected regardless of your choice of gender presentation.<br />
<br />
Esprit is a private event and occurs on private property, in a public setting, and both the hotel's and Esprit's rules of conduct apply. Lewd, lascivious, offensive, intrusive or fetish behavior by attendees or visitors, determined solely at Esprit's discretion, will not be tolerated and Esprit reserves the right to refuse admission or cancel the remaining portion of an attendee's participation if this code is violated.";

$GLOBALS['sig_intro'] = "The statement below will appear on the official confirmation letter you will receive. Your physical signature is not required.";

$GLOBALS['sig_agreement'] = "I agree to abide by the <span class=\"i\">Esprit</span> Rules of Conduct and attest to the fact that I will be at least 21 years of age upon arrival at <span class=\"i\">Esprit, unless attending as a child of an attendee</span>. If a couple, I attest that we are a couple in a legally recognized relationship or who have been living together (maintaining the same physical residence) continuously for the past 12 months.";

$GLOBALS['refund_policy'] = "Refunds will be made only upon written request. Requests postmarked on or before {$date_text['refund_full_deadline']} are eligible for a full refund. Requests postmarked between {$date_text['refund_full_closed']} and {$date_text['refund_50_deadline']} inclusive are eligible for a 50% refund. No refunds if postmarked on or after {$date_text['refund_50_closed']}. Extenuating circumstances will be considered at Esprit's sole discretion. If payment was made via PayPal, the refund will be reduced by any amount not returned to Esprit by PayPal.";

/*
	Mailing address for registrations - may change from year to year.
	Note: two versions: HTML and plain text.
*/

$GLOBALS['esprit_address'] = 'Esprit Registrar, PO BOX 2902, ISSAQUAH WA 98027-0132';
$GLOBALS['esprit_address_text'] = 'Esprit Registrar\nPO BOX 2902\nISSAQUAH WA 98027-0132\n';

/*
	Some directories, defined here for consistency and conciseness.
*/
$GLOBALS['badgephotodir'] = "{$_SERVER['DOCUMENT_ROOT']}/.data/badgephotos/{$GLOBALS['esprit_year']}/";
$GLOBALS['badgephotouri'] = "/.data/badgephotos/{$GLOBALS['esprit_year']}/";
$GLOBALS['badgephotourl'] = "{$_SERVER['REQUEST_SCHEME']}://{$_SERVER['HTTP_HOST']}{$GLOBALS['badgephotouri']}";

$GLOBALS['qrcodedir'] = "{$_SERVER['DOCUMENT_ROOT']}/.data/qrcode/attendee/{$GLOBALS['esprit_year']}/";
$GLOBALS['qrcodeuri'] = "/.data/qrcode/attendee/{$GLOBALS['esprit_year']}/";
$GLOBALS['qrcodeurl'] = "{$_SERVER['REQUEST_SCHEME']}://{$_SERVER['HTTP_HOST']}{$GLOBALS['qrcodeuri']}";

$GLOBALS['badgeicondir'] = "{$_SERVER['DOCUMENT_ROOT']}/lib/badgeicons/";
$GLOBALS['badgeiconuri'] = "/lib/badgeicons/";
$GLOBALS['badgeiconurl'] = "{$_SERVER['REQUEST_SCHEME']}://{$_SERVER['HTTP_HOST']}{$GLOBALS['badgeiconuri']}";

$GLOBALS['pixdir'] = "{$_SERVER['DOCUMENT_ROOT']}/pix/";
$GLOBALS['pixuri'] = "/pix/";
$GLOBALS['pixurl'] = "{$_SERVER['REQUEST_SCHEME']}://{$_SERVER['HTTP_HOST']}{$GLOBALS['pixuri']}";

?>
