/*
	jeditable_setup.js
	Listener class declarations for jEditable. These are common to nearly all templates
	used in the system. Be aware of the possible wide-ranging consequences of making
	changes here.
*/

$(document).ready(function() { 
	$.ajaxSetup ( { 
		// Disable caching of AJAX responses
		cache: false
	} );
	
	//	General text field
	$('.edit').editable('../save.php', { 
		placeholder	: '<span class="jeditable_placeholder">Click to edit</span>',
		indicator	: '<img src="../images/loading.gif">'
	} );
	
	//	HTML field using CKEditor
	$('.edit_html').editable('../save.php', {
		placeholder	: '<span class="jeditable_placeholder">Click to edit</span>',
		indicator	: '<img src="../images/loading.gif">',
		loadurl		: '../load.php',
		type		: 'ckeditor',
		submit		: 'OK',
		cancel		: 'Cancel',
		onblur		: 'ignore'
	} );
	
	//	HTML field using CKEditor but not processing field further before saving.
	$('.edit_html_intact').editable('../save_intact.php', {
		placeholder	: '<span class="jeditable_placeholder">Click to edit</span>',
		indicator	: '<img src="../images/loading.gif">',
		loadurl		: '../load.php',
		type		: 'ckeditor',
		submit		: 'OK',
		cancel		: 'Cancel',
		onblur		: 'ignore'
	} );
	
	//	Drop-down menu field.
	//	Menu values are read from $appname/fieldlist.php for the required field.

	$('.edit_select').editable('../save.php', { 
		placeholder	: '<span class="jeditable_placeholder">Click to edit</span>',
		indicator	: '<img src="../images/loading.gif">',
		loadurl		: '../loadselects.php?appname='+$appname,
		type		: 'select',
		onblur		: 'submit',
//		submit		: 'OK',
//		cancel		: 'Cancel',
		style		: 'inherit'
	} );
	
	//	Textarea field.
	//	Limited to 4 rows; longer data is scroll-barred.
	$('.edit_area').editable('../save.php', {	//	Minimum 4 rows text area
		placeholder	: '<span class="jeditable_placeholder">Click to edit</span>',
		indicator	: '<img src="../images/loading.gif">',
		type		: 'textarea',
		rows		: '4',
		submit		: 'OK',
		cancel		: 'Cancel',
		onblur		: 'ignore'
	} );
	
	//	Textarea field.
	//	Expands to show all data or to the available display space.
	$('.edit_area_full').editable('../save.php', {	//	Dynamically sized textarea
		placeholder	: '<span class="jeditable_placeholder">Click to edit</span>',
		indicator	: '<img src="../images/loading.gif">',
		type		: 'textarea',
		rows		: '10',
		cols		: '80',
		loadurl		: '../load.php',	//	Load underlying HTML, not marked up
		submit		: 'OK',
		cancel		: 'Cancel',
		onblur		: 'ignore'
	} );
	
	//	Date picker with time.
	$('.edit_date').editable('../save.php?datatype=date', { 
		type		: 'datepicker',
		indicator	: '<img src="../images/loading.gif">',
		datepicker	: { format:'d/mm/Y H:iA'},
		ampm		: true,
		tooltip		: 'Click to edit'
	} );
	
	//	Checkbox with 0 and 1 values.
	$('.checkbox').editable('../save.php', {
		type		: 'checkbox',
//		cancel		: 'Cancel',
		submit		: 'OK',
		onblur		: 'submit',
		tooltip		: 'Click to change',
		checkbox	: { trueValue: '1', falseValue: '0' }
	} );
	
	//	Checkbox with No and Yes values.
	$('.checkboxyn').editable('../save.php', {
		type		: 'checkbox',
//		cancel		: 'Cancel',
		submit		: 'OK',
		onblur		: 'submit',
		tooltip		: 'Click to change',
		checkbox	: { trueValue: 'Yes', falseValue: 'No' }
	} );
	
	//	Phone number with automatic masking.
 	$('.edit_phone').editable('../save.php', { 
		type		: 'masked',
		mask		: '999-999-9999?x9999',
		indicator	: '<img src="../images/loading.gif">',
		submit		: 'OK',
		cancel		: 'Cancel',
		onblur		: 'ignore'
	} );
	
	$('.menu').menu();
 } );
