<?php

function titleCase($string) {
	
	/*	Correct case of proper names */
	
	$word_splitters = [' ', '-', "O'", "L'", "D'", 'St.', 'Mc', 'Mac'];
	$lowercase_exceptions = ['the', 'van', 'den', 'von', 'und', 'der', 'de', 'da', 'of', 'and', "l'", "d'"];
	$uppercase_exceptions = ['III', 'IV', 'VI', 'VII', 'VIII', 'IX', 'X', 'XI', 'MD', 'USA', 'NW', 'NE', 'SE', 'SW'];
	$string = strtolower($string . '');
	foreach ($word_splitters as $delimiter) {
		$words = explode($delimiter, $string);
		$newwords = [];
		foreach ($words as $word) {
			if (in_array(strtoupper($word), $uppercase_exceptions)) {
				$word = strtoupper($word);
			} else {
				if (!in_array($word, $lowercase_exceptions)) {
					$word = ucfirst($word);
				}
			}
			$newwords[] = $word;
		}
		if (in_array(strtolower($delimiter), $lowercase_exceptions))
		$delimiter = strtolower($delimiter);$string = join($delimiter, $newwords);
	}
	return trim($string);
}

function get_constants() {

	/* Get common constants for emailing */
	
	global $esprit_year;
	$constants['timestamp'] = date('Y-m-d H:i:s');	/*	timestamp of posting */
	$constants['esprit_year'] = $esprit_year;
	return $constants;
}

function get_m() {

	/* Get email boilerplate constants */

	global $date_text, $esprit_address, $esprit_address_text, $conduct_text, $refund_policy, $sig_agreement;
	$m['esprit_address'] = $esprit_address;
	$m['esprit_address_text'] = $esprit_address_text;
	$m['payment_deadline'] = $date_text['payment_deadline'];
	$m['refund_full_deadline'] = $date_text['refund_full_deadline'];
	$m['refund_full_closed'] = $date_text['refund_full_closed'];
	$m['refund_50_deadline'] = $date_text['refund_50_deadline'];
	$m['refund_50_closed'] = $date_text['refund_50_closed'];
	$m['conduct_text'] = $conduct_text;
	$m['refund_policy'] = $refund_policy;
	$m['sig_agreement'] = $sig_agreement;
	return $m;
}

function get_server_vars() {

	/*	Get server variables */

	if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
		$sm['ip'] = $_SERVER['HTTP_X_FORWARDED_FOR'];
	} else {
		$sm['ip'] = $_SERVER['REMOTE_ADDR'];
	}
	$sm['user_agent'] = $_SERVER['HTTP_USER_AGENT'];
	return $sm;
}

function sanitise($table_name, $p_in, $common) {

	/*	Clean up input, expand arrays, recapitalise fields etc. */

	global $packages, $date;
// 	print '<h4>' . __FUNCTION__ . '/' . __LINE__ . ": Processing \$table_name: $table_name</h4>";
// 	print '<h4>' . __FUNCTION__ . '/' . __LINE__ . ": Contents of \$p_in: </h4><pre>"; print_r($p_in); print '</pre>';

	$p = array_merge($p_in, $common);		//	Merge in common fields
	foreach ($p as $this_value => $value) {	//	Can't simply assign the array
		if (!is_array($value)) {			//	as we have to avoid sub-arrays
			$r[$this_value] = $value;
		}
	}
	
	switch ($table_name) {	//	Then clean up individual values as required

	case 'reg':

		/*	Some forms leave these fields blank. Fill in with default values. */

		$r['firstnamepref'] = titleCase((trim($p['firstnamepref']) == '') ?
			$p['firstname'] : $p['firstnamepref']);
		$r['lastnamepref'] = titleCase((trim($p['lastnamepref']) == '') ?
			$p['lastname'] : $p['lastnamepref']);
		$r['littlesis'] = isset($p['littlesis']) ? $p['littlesis'] : 'No';
		$r['bigsis'] = isset($p['bigsis']) ? $p['bigsis'] : 'No';
		$r['bslsage'] = isset($p['bslsage']) ? $p['bslsage'] : 0;
		
		/*	Calculate valid checkin date based on package */
		$pkg_prefix = substr($p['ratepkg'], 0, 2);
		switch (true) {
		case $pkg_prefix == 'SS':
			$r['checkinvalid'] = $date['checkin_valid_SS'] -> format("YmdHis");
			break;
		case $pkg_prefix == 'WS':
			$r['checkinvalid'] = $date['checkin_valid_WS'] -> format("YmdHis");
			break;
		case $pkg_prefix == 'FS':
			$r['checkinvalid'] = $date['checkin_valid_FS'] -> format("YmdHis");
			break;
		default:
			$r['checkinvalid'] = $date['esprit_start'] -> format("YmdHis");
			break;
		}

		/*	These fields need case correction. Note that titleCase does trim()
			internally */

		$r['firstname'] = titleCase($p['firstname']);
		$r['lastname'] = titleCase($p['lastname']);
		$r['relto_firstnamepref'] = array_key_exists('relto_firstnamepref', $p) ? titleCase($p['relto_firstnamepref']) : '';
		$r['relto_lastnamepref'] = array_key_exists('relto_lastnamepref', $p) ? titleCase($p['relto_lastnamepref']) : '';
		$r['address'] = trim(ucwords(strtolower($p['address'])));
		$r['city'] = trim(ucwords(strtolower($p['city'])));
		$r['state'] = trim(strtoupper($p['state']));
		$r['zip'] = trim(strtoupper($p['zip']));
		$r['country'] = titleCase($p['country']);
		$r['nametoaskfor'] = trim(ucwords(strtolower($p['nametoaskfor'])));
		
		/*	Set the is_presenter and is_vendor flags only if the field is
			present AND is either "yes" or "true". */
		
		if (!array_key_exists('is_presenter', $p)) {
			$p['is_presenter'] = 'No';
		}
		$r['is_presenter'] = in_array(strtolower($p['is_presenter']), ['yes', 'true']) ? 'Yes' : 'No';
		if (!array_key_exists('is_vendor', $p)) {
			$p['is_vendor'] = 'No';
		}
		$r['is_vendor'] = in_array(strtolower($p['is_vendor']), ['yes', 'true']) ? 'Yes' : 'No';

		/*	Translate various forms of USA, United States etc. into uppercase
			USA for consistency. */
		
		if (in_array(strtoupper($r['country']), ['UNITED STATES', 'US', 'U S A', 'U.S.A.', 'U.S.A'])) {
			$r['country'] = 'USA';
		}

		/*	These fields need to be copied from others if no value was entered */
		
		$r['safe_address'] = trim($r['safe_address'] == '' ? $r['address'] : $r['safe_address']);
		$r['safe_city'] = trim($r['safe_city'] == '' ? $r['city'] : $r['safe_city']);
		$r['safe_state'] = trim($r['safe_state'] == '' ? $r['state'] : $r['safe_state']);
		$r['safe_zip'] = trim($r['safe_zip'] == '' ? $r['zip'] : $r['safe_zip']);
		$r['safe_country'] = trim($r['safe_country'] == '' ? $r['country'] : $r['safe_country']);
		
		/*	These fields need to be converted to boolean from Yes/No and
			true/false text (as returned by checkboxes) */
		
		$m['yearbookphoto'] = $p['yearbookphoto'];		//	NOT in database!

		/*	Initialise meal checked counters. These decrement whenever the ID
			badge is scanned for the corresponding meal. 
			Modified 2019-06-11 to exclude meal1 (obsolete Veterans' Breakfast)
		*/
		for ($i = 2 ; $i <= 6 ; $i++) {
			if ($p["meal$i"] == '') $p["meal$i"] = 0;
			$r["meal$i"] = $r["meal{$i}checked"] = $p["meal$i"];
// 			die($p['meal$i']);
		}
		/*	These fields need to be converted to Yes/No from Yes/true/No/null */
		
		if (!array_key_exists('scholapplication', $p)) {
			$p['scholapplication'] = 'No';
		}
		$r['scholapplication'] = in_array(strtolower($p['scholapplication']), ['yes', 'true']) ? 'Yes' : 'No';

		/*	Convert day array into individual fields. If a package name is
			supplied that does NOT begin with 'SD' ("selected days") then pick
			up the days associated with that package; otherwise use the
			checkboxes clicked by the user. */
// 		$pkg = $p['ratepkg'];
// 		if (substr($pkg, 0, 2) == 'SD') {	// Individually-selected days
// 			$r['daysun1'] = $p['daysun1'];
// 			$r['daymon'] = $p['daymon'];
// 			$r['daytue'] = $p['daytue'];
// 			$r['daywed'] = $p['daywed'];
// 			$r['daythu'] = $p['daythu'];
// 			$r['dayfri'] = $p['dayfri'];
// 			$r['daysat'] = $p['daysat'];
// 			$r['daysun2'] = $p['daysun2'];
		
// 		} else {
// 			/*	Walk the $packages array for matching code. Not going to try
// 				parsing the code as it would mean updating this every time a new
// 				code was added. */
// 			$stop = false;
// 			foreach ($packages as $this_p => $package) {
// 				foreach ($package as $this_type => $package_type) {
// 					foreach ($package_type as $this_range => $range) {
// 						if ($pkg == $range['code']) {	//	Match
// 							$d = $range['days'];
// 							$stop = true;
// 							break;
// 						}
// 						if ($stop) break;
// 					}
// 					if ($stop) break;
// 				}
// 				if ($stop) break;
// 			}
// 			$r['daysun1'] = $d[0];
// 			$r['daymon'] = $d[1];
// 			$r['daytue'] = $d[2];
// 			$r['daywed'] = $d[3];
// 			$r['daythu'] = $d[4];
// 			$r['dayfri'] = $d[5];
// 			$r['daysat'] = $d[6];
// 			$r['daysun2'] = $d[7];
// 		} 		//	Package code is SD-x-xx, pick up checkboxes
		break;
	
	case 'scholapp':

		/*	All fields should have been validated at time of entry. */

		break;
	
	case 'regvendor':
	
		/*	Vendor info only */
		
		$r = $p;		//	Get everything copied over, then tweak as required. These
						//	fields all need to be non-null in order for copying from
						//	one year to the next to work, so we zero them if null.
		/*	Room layout */
		$r['flyer'] = isset($p['flyer']) ? $p['flyer'] : 0;
		$r['desk'] = isset($p['desk']) ? $p['desk'] : 0;
		$r['deskchair'] = isset($p['deskchair']) ? $p['deskchair'] : 0;
		$r['mirror'] = isset($p['mirror']) ? $p['mirror'] : 0;
		$r['bigchair'] = isset($p['bigchair']) ? $p['bigchair'] : 0;
		$r['nightstands'] = isset($p['nightstands']) ? $p['nightstands'] : 0;
		$r['table6x35'] = isset($p['table6x35']) ? $p['table6x35'] : 0;
		$r['table6x15'] = isset($p['table6x15']) ? $p['table6x15'] : 0;
		$r['foldchairs'] = isset($p['foldchairs']) ? $p['foldchairs'] : 0;
		$r['rollaways'] = isset($p['rollaways']) ? $p['rollaways'] : 0;
		/*	AV requirements */
		$r['avproj'] = isset($p['avproj']) ? $p['avproj'] : 0;
		$r['avslideproj'] = isset($p['avslideproj']) ? $p['avslideproj'] : 0;
		$r['avscreen'] = isset($p['avscreen']) ? $p['avscreen'] : 0;
		$r['avcd'] = isset($p['avcd']) ? $p['avcd'] : 0;
		$r['avdvd'] = isset($p['avdvd']) ? $p['avdvd'] : 0;
		$r['avvcr'] = isset($p['avvcr']) ? $p['avvcr'] : 0;
		$r['avoverhead'] = isset($p['avoverhead']) ? $p['avoverhead'] : 0;
		$r['avmic'] = isset($p['avmic']) ? $p['avmic'] : 0;
		$r['avpodium'] = isset($p['avpodium']) ? $p['avpodium'] : 0;
		$r['avmonitor'] = isset($p['avmonitor']) ? $p['avmonitor'] : 0;
		$r['avpiano'] = isset($p['avpiano']) ? $p['avpiano'] : 0;

	}
//  		print __FUNCTION__ . ":\$r <pre>"; print_r($r); print '</pre>';
	return $r;

}


function build_trans($t, $conf_to_link, $this_conf, $sourceacct = '', $sourceuser = '') {

	/*	Build transaction table record */
//  	print __FUNCTION__ . ": Incoming:<pre>";print_r($t);print "</pre><br />";
	
	
	$r = [
		'confirmation' => $conf_to_link,
		'reference' => $this_conf,
		'transtype' => 'Registration',
		'quantity' => 1,
		'amount' => $t['fee'],
		'tax' => $t['tax'],	//	Preloaded in table
		'source' => "{$t['form_type']} Registration submitted",
		'pnotes' => "{$t['firstnamepref']} {$t['lastnamepref']} {$this_conf} ({$t['ratepkg']})",
		'username' => $sourceuser,
		'authgroup' => $sourceacct
	];
// 	print __FUNCTION__ . ": \$t array:<pre>";print_r($t);print "</pre><br />";
//  	print __FUNCTION__ . ": Returning:<pre>";print_r($r);print "</pre><br />";
	return $r;
}

function build_bal_forward_trans($t, $conf_to_link, $this_conf, $email, $sourceacct = '', $sourceuser = '') {
// print "Parameters received: \$t="; print_r($t); print ", \$conf_to_link=$conf_to_link, \$this_conf=$this_conf, \$email=$email, \$sourceacct=$sourceacct, \$sourceuser=$sourceuser<br/>";

	/*	Generate balance forward record */
	require_once "mysql_utilities.php";
	mysql_login();
	$echeck = $GLOBALS['esprit_year'] - 1;
	$sqlcmd = "SELECT sum(amount) amt
	FROM regpayment
	WHERE confirmation IN 
		(SELECT confirmation_no
		FROM regall
		WHERE email='$email'
			AND reg_status != 'DELETED'
			AND esprit_year=$echeck)";
	$result = mysqli_query($GLOBALS['dbConnect'], $sqlcmd) or die(__FUNCTION__.': MySQL error: '.mysqli_error($GLOBALS['dbConnect']).'. Trying to compute balance forward; Query='.$sqlcmd);

	$bal_row = mysqli_fetch_assoc($result);
	
/*	Only return a balance forward if it's a credit balance. Otherwise we'll ding 
	people who registered last year but never paid or attended. */
	
	if (is_null($bal_row) or ($bal_row <= 0)) {
		$r = null;	//	No balance forward to return
	} else {
		$amt = $bal_row['amt'];
	
		$r = [
			'confirmation' => $conf_to_link,
			'reference' => $this_conf,
			'transtype' => 'Registration',
			'quantity' => 1,
			'amount' => $amt,
			//	No tax on bakance forward!
			'source' => "{$t['form_type']} Balance forward from $echeck",
			'pnotes' => "{$t['firstnamepref']} {$t['lastnamepref']} (email: $email)",
			'username' => $sourceuser,
			'authgroup' => $sourceacct
		];
	// 	print __FUNCTION__ . ": \$t array:<pre>";print_r($t);print "</pre><br />";
	// 	print __FUNCTION__ . ": Returning:<pre>";print_r($r);print "</pre><br />";
	}
	mysql_logout();	//	Disconnect from database

	return $r;
}


function build_addon_trans($t, $conf_to_link, $sourceacct = '', $sourceuser = '') {
	global $mealnames, $esprit_year;
//	meal1 is the obsolete Veterans' Breakfast, never enabled any more.
// 	$meal1enabled = $mealnames['meal1']['enabled'] ? 1 : 0;

	/*	Build transaction table record from addon entries */
	/*	This is a little more involved as we have to look up the entry details
		from the regaddons database.
		$t is an array of addon IDs. All we care about is the index, which is the item ID in the database. */

	$postable = array();
	foreach ($t as $this_t => $t_item) {	//	Extract only nonzero purchases
		if ($t_item > 0) {
			$postable[$this_t] = $t_item;
		}
	}
	$keylist = implode(',',array_keys($postable));
	if ($keylist == '') {	//	No add-ons, return empty array
		return array();
	}
// 	print __FUNCTION__ . ": key list=$keylist<br />";
	require_once "mysql_utilities.php";
	mysql_login();
	$sqlcmd = "SELECT *
	FROM regaddons
	WHERE addon_id IN($keylist)";
	$result = mysqli_query($GLOBALS['dbConnect'], $sqlcmd) or die(__FUNCTION__.': MySQL error: '.mysqli_error($GLOBALS['dbConnect']).'. Trying to get linked-to info; Query='.$sqlcmd);
	$r = array();
	$mealupdateclause = '';		//	for updating meal counts on badges
	while ($row = mysqli_fetch_assoc($result)) {
		$q = $t[$row['addon_id']];
// print '<pre>';print_r($q); print'<br /></pre>';
		$qty = $q['quantity'];
		$unit = ($qty == 0) ? $q['addon_price'] : $q['addon_price'] / $qty;
		if ($q['quantity'] >0) {	//	Nonzero amounts only

			$r[] = [
				'confirmation' => $conf_to_link,
				'reference' => $conf_to_link,
				'transtype' => $row['addon_type'],
				'quantity' => $qty,
				'amount' => $q['addon_price'],
				'tax' => $q['tax'],
				'source' => ($qty <= 1) ? 'Item purchased' : "$qty items purchased",
				'pnotes' => "{$row['addon_name']} @ \$$unit",
				'addon_key' => $row['addon_id'],
				'addon_pointer' => $row['addon_desc_link'],
				'username' => $sourceuser,
				'authgroup' => $sourceacct
			];
		}
// 	 			print __FILE__ .':'. __LINE__ . ":\$qty=$qty";
	/*
			Now prepare to update meal counts for badges if any extra meals were
			purchased. All we do at this point is create the MySQL update
			clause; the actual update is done after all the other add-ons are
			processed.
			We use the addon_desc_link which indicates the meal field to
			increment.
		*/
		if ($row['addon_type'] == 'Meals') {	//	Meal?
			$m = $row['addon_desc_link'];		//	Which one?
			if ($m === '*') {	//	All of them. Starting at 2 makes it skip the
								//	obsolete meal1 (Veterans' Breakfast).
				for ($i = 2; $i <= 6; $i++) {
					$mealupdateclause .= "meal{$i}=meal{$i}+$qty,meal{$i}checked=meal{$i}checked+$qty,";
				}
			} else {
				$mealupdateclause .= "meal$m=meal$m+$qty,meal{$m}checked=meal{$m}checked+$qty,";
			}
		}
	}
	
//	die("\$mealupdateclause=$mealupdateclause");
	
	
	
	if ($mealupdateclause != '') {
		$mealupdateclause = rtrim($mealupdateclause, ',');
		$sqlcmd = "UPDATE reg SET $mealupdateclause WHERE confirmation_no=$conf_to_link";
// 			print '<h4>' . __FUNCTION__ . ": updating meal count; \$sqlcmd=$sqlcmd </h4>";
		$rmeal = mysqli_query($GLOBALS['dbConnect'], $sqlcmd) or die(__FUNCTION__.': MySQL error: '.mysqli_error($GLOBALS['dbConnect']).'. Trying to update meal counts; Query='.$sqlcmd);
	}
// 	print __FUNCTION__ . ": Returning:<pre>";print_r($r);print "</pre><br />";
	mysql_logout();	//	Disconnect from database
	return $r;
}

function generate_paypal_link($acct, $conf = null, $amt = 0) {

	/*	Generate link to PayPal */
	global $esprit_year;
	if ($conf == null) {
		return "No confirmation number given.";
	}
	if ($amt == 0) {
		return "No balance outstanding.";
	}
	$amt = (TESTING) ? 1 : $amt + $tax;
	$r = "<form action=\"paypalcode/payments.php\" method=\"post\" target=\"_top\">
		<input type=\"hidden\" name=\"cmd\" value=\"_xclick\">
		<!-- input type=\"hidden\" name=\"hosted_button_id\" value=\"U2HJWL7V8B38G\" -->
		<input type=\"image\" src=\"https://www.paypalobjects.com/en_US/i/btn/btn_paynow_LG.gif\" border=\"0\" name=\"submit\" alt=\"PayPal - The safer, easier way to pay online!\">
		<input type=\"hidden\" name=\"lc\" value=\"US\" />
		<input type=\"hidden\" name=\"currency_code\" value=\"USD\" />
		<input type=\"hidden\" name=\"item_name\" value=\"Esprit $esprit_year Registration ID $conf per CNE TransVentions\" />
		<input type=\"hidden\" name=\"amount\" value=\"$amt\" />
		<input type=\"hidden\" name=\"tax\" value=\"$tax\" />
		<input type=\"hidden\" name=\"custom\" value=\"$conf\" />
		<img alt=\"\" border=\"0\" src=\"https://www.paypalobjects.com/en_US/i/scr/pixel.gif\" width=\"1\" height=\"1\">
	</form>";
	return $r;
}

function paramdump($r, $f, $title = '') {

	/*	Pretty-print an array (used mostly to debug $_REQUEST array for form
		postings) */
	
	print '<h4>' . __FUNCTION__ . ":$title: Parameter Dump:</h4>";
	print '<pre>'; print var_export($r, true); print '</pre>';
	print '<br />';
	print '<h4>' . __FUNCTION__ . ":$title: File Parameter Dump:</h4>";
	print '<pre>'; print var_export($f, true); print '</pre>';
}

function get_conf_email($p) {

	/*	Get the appropriate confirmation number and email address, given an
		array of submitted values. */
//   	print __FUNCTION__ . ' parameters:<pre>'; print_r($p);print '</pre><br />';
	if (isset($p['noupload']['source_form_type'])) {
		switch ($p['noupload']['source_form_type']) {
		case 'Attendee':
			$loc = $p['Single'];
			break;
		case 'Scholarship':
			$loc = $p['Scholarship'];
			break;
		default:
			if (isset($p['common']['email'])) {
				$loc = $p['common'];
			} else {
				$loc = $p[$p['noupload']['source_form_type']];
			}
		}
	} elseif (isset($p['form_type'])) {
		$loc = $p[$p['form_type']];
	}
//  	print __FUNCTION__ . ' \$loc:<pre>'; print_r($loc);print '</pre><br />';
	$r['email'] = $loc['email'];
	$r['confirmation_no'] = $loc['confirmation_no'];
//  	print __FUNCTION__ . ' result:<pre>'; print_r($r);print '</pre><br />';
	return $r;
}
?>