<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 23 November, 2017
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');

/* MySQL table names */
if ($all_years) {	//	All years
$db['tb'] = 'regmealtypesall m';
$db['tbnoalias'] = 'regmealtypesall';
	$db['alias'] = 'm';		//	Need this for duplicating records. Only fields
							//	with a table spec matching this alias will be
							//	used in the get_mysql_fields() function.
} else {	//	Current year only
$db['tb'] = 'regmealtypes m';
$db['tbnoalias'] = 'regmealtypes';
	$db['alias'] = 'm';		//	Need this for duplicating records. Only fields
							//	with a table spec matching this alias will be
							//	used in the get_mysql_fields() function.
}

global $opts, $all_years;
$opts['join_clause'] = '';

/* Field definitions start here */

$fields['mt_abbr'] = [
		'heading' => "Abbr.",
		'long_heading' => "Meal Abbreviation",
		'table' => 'm',
		'display' => true,
		'width' => '5%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master, Copy',
		'filter' => ""];
$fields['mt_year'] = [
		'heading' => "Year",
		'table' => 'm',
		'display' => true,
		'width' => '5%',
		'copyValue'=> $GLOBALS['esprit_year'],
		'arrayedit' => true,
		'fieldgroup' => '*, Master, Copy',
		'filter' => ""];
$fields['mt_long'] = [
		'heading' => "Long Name",
		'table' => 'm',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master, Copy',
		'filter' => ""];
$fields['mt_verbose'] = [
		'heading' => "Verbose Name",
		'table' => 'm',
		'display' => true,
		'width' => '30%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master, Copy',
		'filter' => ""];
$fields['mt_desc'] = [
		'heading' => "Description",
		'long_heading' => "Meal Description",
		'table' => 'm',
		'display' => true,
		'width' => '30%',
		'arrayedit' => true,
		'widget' => 'ckeditor',
		'fieldgroup' => '*, Copy',
// 		'truncate_display' => '60',
		'filter' => ""];
$fields['mt_weekday'] = [
		'heading' => "Weekday",
		'table' => 'm',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'widget' => 'menu',
		'allowedvalues' => ['S', 'M', 'T', 'W', 'R', 'F', 'A', 'U'],
		'allowedlabels' => ['Sun1', 'Mon', 'Tue', 'Wed', 'Thu',
			'Fri', 'Sat', 'Sun2'],
		'fieldgroup' => '*, Master, Copy',
		'filter' => ""];
$fields['mt_mealtime'] = [
		'heading' => "Meal Time",
		'table' => 'm',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'widget' => 'menu',
		'allowedvalues' => ['B', 'M', 'L', 'A', 'D', 'E', 'S'],
		'allowedlabels' => ['Breakfast', 'Morning', 'Lunch', 'Afternoon',
			'Dinner', 'Evening', 'Special'],
		'fieldgroup' => '*, Master, Copy',
		'filter' => ""];
$fields['mt_cost'] = [
		'heading' => "Cost",
		'long_heading' => "Meal Cost",
		'table' => 'm',
		'display' => true,
		'width' => '5%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master, Copy',
		'filter' => ""];
$fields['tax'] = [
		'heading' => "Tax",
		'long_heading' => "Tax",
		'table' => 'm',
		'display' => true,
		'width' => '5%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master, Copy',
		'filter' => ""];
$fields['mt_enabled'] = [
		'heading' => "Enabled?",
		'long_heading' => "Meal Type Enabled?",
		'table' => 'm',
		'display' => true,
		'width' => '5%',
		'widget' => 'menu',
		'allowablelabels' => ['Yes', 'No'],
		'allowablevalues' => ['Yes', 'No'],
		'arrayedit' => true,
		'fieldgroup' => '*, Master, Copy',
		'filter' => ""];
$fields['mt_notes'] = [
		'heading' => "Notes",
		'long_heading' => "Notes for Meal Type",
		'labelhelp' => 'These are for internal notekeeping only. They don\'t appear anywhere else.',
		'table' => 'm',
		'display' => true,
		'width' => '25%',
		'arrayedit' => true,
		'widget' => 'ckeditor',
		'fieldgroup' => '*, Master, Copy',
		'filter' => ""];
$fields['mt_created'] = [
		'heading' => "Created",
		'table' => 'm',
		'display' => true,
		'search_more' => true,
		'copyValue' => null,
		'width' => '10%',
		'fieldgroup' => 'Master, Detail',	//	No copy to new
		'filter' => ""];
$fields['mt_updated'] = [
		'heading' => "Updated",
		'table' => 'm',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'search_more' => true,
		'copyValue' => null,
		'width' => '10%',
		'fieldgroup' => 'Master, Detail',	//	No copy to new
		'filter' => ""];
$fields['mt_id'] = [
'heading' => 'Entry number',
		'primarykey' => true,
		'table' => 'm',
		'display' => true,
		'search_more' => true,
		'fieldgroup' => '*',
		'filter' => ""];

/* End of Field definitions. */

/* Field group definitions */

if (!$all_years) {
	//	Current year only
	$tpl['fieldgroups'] = [
	/*	'Blank' => ['label' => '>',
			'url' => 'blank.php'], */
		'Master' => ['label'=>'Master',
			'url' =>''],
		'Detail' => ['label' => 'Details',
			'url' => 'taburl.php?template=mealtype_detail.tpl',
			'authgroup' => ['Admin']],
		'AddNew' => ['label' => 'Copy',
			'url' => 'add.php',
			'authgroup' => ['Admin'],
			'scroll' => 'No'	//	Prevent scrolling to this screen
		],
		'Logs' => ['label' => 'Log Entries',
			'url' => "../log-list.php?tbname={$db['tbnoalias']}",
			'width' => 1500,
			'height' => 800,
			'authgroup' => ['Admin']],
		'DeleteThis' => ['label' => 'Delete',
			'url' => 'delete.php',
			'authgroup' => ['Admin'],
			'scroll' => 'No',	//	Prevent scrolling to this screen
			],
		'All' => ['label' => 'All Fields',
			'url' => '../allfieldsurl.php?dirname=mealtypes',
			'authgroup' => ['Admin']]
	];
} else {
	// All years
	$tpl['fieldgroups'] = [
	/*	'Blank' => ['label' => '>',
			'url' => 'blank.php'], */
		'Master' => ['label'=>'Master',
			'url' =>''],
		'Detail' => ['label' => 'Details',
			'url' => 'taburl.php?template=mealtype_detail.tpl&all_years=true&access=read_only',
			'authgroup' => ['Admin']],
		'Logs' => ['label' => 'Log Entries',
			'url' => "../log-list.php?tbname={$db['tbnoalias']}",
			'width' => 1500,
			'height' => 800,
			'authgroup' => ['Admin']],
		'Copy' => ['label' => 'Copy to Current Year',
			'url' => 'copy_to_current.php?all_years=true',
			'authgroup' => ['Admin']],
		'All' => ['label' => 'All Fields',
			'url' => '../allfieldsurl.php?dirname=mealtypes&all_years=true',
			'authgroup' => ['Admin']]

	];
}

?>