<?php
/*	This file generates a list of the payments applicable to a particular
	person. The person is identified by their confirmation number. The list is
	intended for inclusion in an iframe in the accounts_detail.tpl template:
	
		<iframe src="payment-list.php?confirmation={$mydata.confirmation_no}&fee={$mydata.fee}&ratepkg={$mydata.ratepkg}&submit={$mydata.timestamp}" height="150" width="500"></iframe>

*/
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");	// WAAAY in the past
header("Cache-Control: no-cache");
header("Pragma: no-cache");
print '<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">';
print '<style>
.tiny {		/*	For annotations */
	font-size: 0.75em;
}
.input-res {	/*	Responsive input fields */
	-webkit-appearance: none;
	-moz-appearance: none;
	appearance: none;
/* 	font: 15px/1 \'Open Sans\', sans-serif; */
/*	color: #333; */
	-webkit-font-smoothing: antialiased;
	-moz-osx-font-smoothing: grayscale;
	width: 100%;
	max-width: 500px;
	background-color: #eeeeee;
	border: 1px solid silver;
	padding: 2px;
	border-radius: 3px;
	box-shadow: none;
	outline: none;
	margin: 0;
	box-sizing: border-box; 
}
</style>';
print '<link href="css/styles.css" rel="stylesheet" type="text/css" media="all">';
print '<link href="css/reports.css" rel="stylesheet" type="text/css" media="all">';
require_once "{$_SERVER['DOCUMENT_ROOT']}/lib/mysql_utilities.php";
print '<script>  $( function() {
    $( "#delete-confirm" ).dialog({
      resizable: false,
      height: "auto",
      width: 400,
      modal: true,
      buttons: {
        "Delete all items": function() {
          $( this ).dialog( "close" );
        },
        Cancel: function() {
          $( this ).dialog( "close" );
        }
      }
    });
  } );
	function urldecode(str) {
	   return decodeURIComponent((str+"").replace(/\+/g, "%20"));
	};
	function update_posting(j_piece) {
	piece = JSON.parse(urldecode(j_piece));
	document.getElementById("_transtype").value=piece.addon_type;
	document.getElementById("reference").value=document.getElementById("confirmation").value;
	document.getElementById("source_id").value="Item purchased";
	document.getElementById("pnotes_id").value=piece.addon_name;
	document.getElementById("addon_desc_link_id").value=piece.addon_desc_link;
	document.getElementById("addon_key_id").value=piece.addon_id;
	document.getElementById("addon_pointer_id").value=piece.addon_desc_link;
	document.getElementById("amount_id").value=piece.addon_price;
	document.getElementById("tax_id").value=piece.tax;
	};
</script>';
mysql_login('Normal');

$db['tb'] = 'regpayment';
$db['tb2'] = 'reg';

$confirmation_no = $_REQUEST['confirmation'];
$this_submit = $_REQUEST['submit'];
$username = $_REQUEST['username'];
$authgroup = $_REQUEST['authgroup'];
// Force caching to expire ASAP or displayed payment info is out of date
//	print '<pre>';print_r($_REQUEST);print '</pre><br />';

/*	Include a mini-form for adding a new payment */
print '<form name="miniform" id="miniform_id" accept-charset="UTF-8" action="paymentexe.php" method="POST">';

/* Get array of transaction types */

define ('QUADODO_IN_SYSTEM', true);
require_once 'trans/fieldlist.php';
$allowedvalues = $fields['transtype']['allowedvalues'];

/*	Also pull in extra values from regaddons table as there are some transaction types
	that aren't included in the addon_type categories. */

$sqltranstypes = "SELECT DISTINCT addon_type
FROM regaddons";
$result = mysqli_query($GLOBALS['dbConnect'], $sqltranstypes) or SM_Die('Database error while selecting addon types: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to retrieve addon types. Sorry!');
while ($av = mysqli_fetch_array($result)) {
	$allowedvalues[] = $av[0];
}
sort($allowedvalues);
print '<table class="row-0">';

if (empty($confirmation_no)) {
	print '<tr><td></td><td class="warning">Missing confirmation no. Cannot locate transactions.</tr>';
} else {

	$sql = "SELECT ratepkg, fee, timestamp, reg_status, confirmation_no
	FROM {$db['db']}.{$db['tb2']}
	WHERE confirmation_no=$confirmation_no";
	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error while selecting rate packages: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to retrieve rate packages for transaction display. Sorry!');
	$row = mysqli_fetch_array($result);
	$reg_status = $row['reg_status'];	// we lose $#row later on
	
	print '<tr class="row-1"><td width="15%">Timestamp<br /><span class="tiny">User/Group</span></td>
	<td width="5%">Rcpt No.</td>
	<td width="15%">Type</td>
	<td width="10%">Reference</td>
	<td width="10%">Qty</td>
	<td width="20%">Source</td>
	<td width="30%">Notes</td>
	<td nowrap class="right" width="10%">Amount</td>
	<td nowrap class="right" width="10%">Tax</td>
	</tr>';
	$balance = 0;
	$tax_balance = 0;

	$sql = "SELECT timestamp, username, authgroup, id, amount, tax, reference, quantity,
		source, pnotes, receipt_no, transtype, addon_key addon_desc_key, addon_pointer
	FROM {$db['db']}.{$db['tb']}
	WHERE confirmation=$confirmation_no
	ORDER BY timestamp";
	
	// print 'Final SQL query: '.$sql;
	
	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to retrieve transactions for display. Sorry!');
	$row_count_result = mysqli_query( $GLOBALS['dbConnect'], 'select FOUND_ROWS() as row_count') or SM_Die('Database error (counting):'. mysqli_error($GLOBALS['dbConnect']), 'Count error while retrieving transactions. Sorry!');
	$temp = mysqli_fetch_array($row_count_result);
	
	// DebugPrint('Row count query result',$temp);
	$record_count = $temp['row_count'];
	while ($row = mysqli_fetch_array($result)) {
		$balance +=$row['amount'];
		$tax_balance +=$row['tax'];
		$transstyle = ($row['timestamp'] == $this_submit) ? 'thistransaction' : 'transaction';
		print '<tr>
		<td class="'.$transstyle.'">'.$row['timestamp'].'<br /><span class="tiny">'.$row['username'] .'/'.$row['authgroup'].'</span></td>
		<td class="'.$transstyle.'">'.$row['receipt_no'].'</td>
		<td class="'.$transstyle.'">'.$row['transtype'].'</td>
		<td class="'.$transstyle.'" style="width:10em">'.$row['reference'].'</td>
		<td class="'.$transstyle.'" style="width:10em">'.$row['quantity'].'</td>
		<td class="'.$transstyle.'">'.$row['source'].'</td>
		<td class="'.$transstyle.'">'.$row['pnotes'].'</td>
		<td class="'.$transstyle.' right">'. sprintf("$%.2f", $row['amount']).'</td>
		<td class="'.$transstyle.' right">'. sprintf("$%.2f", $row['tax']).'</td>
		<td>';
		print (in_array($authgroup, array('Admin', 'Registrar')))
			? "<a href=\"payment-delete.php?id={$row['id']}&confirmation_no=$confirmation_no&addon_key={$row['addon_desc_key']}&addon_pointer={$row['addon_pointer']}&username=$username&authgroup=$authgroup\" onclick=\"return confirm('Are you sure you want to delete?')\">
			<img src=\"/images/sm_delete.png\"></a>&nbsp;
			<!-- div id=\"delete-confirm\"><img src=\"/images/sm_delete.png\"></div -->"
			: '&nbsp;';
		print '</td></tr>';
	}
}
print "<tr class=\"row-0\">
<td></td>
<td></td>
<td><input type=\"hidden\" name=\"confirmation\" id=\"confirmation\" value=$confirmation_no />
<input type=\"hidden\" name=\"fee\" value=$fee />
<input type=\"hidden\" name=\"ratepkg\" value=$ratepkg />
<input type=\"hidden\" name=\"username\" value=\"$username\" />
<input type=\"hidden\" name=\"authgroup\" value=\"$authgroup\" />
<input type=\"hidden\" name=\"submit\" value=$submit />


<select name=\"transtype\" id=\"_transtype\">";
foreach ($allowedvalues as $thisvalue) {
	print "<option value=\"$thisvalue\" >$thisvalue</option>\n";
}
print '</select></td>';
print <<<STUFF
<td><input type="text" class="input-res" size="10%" id="reference" name="reference"><br /><span class="tiny">Reference</span></td>
<td><input type="text" class="input-res" size="10%" id="quantity" name="quantity" value="1" 

onchange="this.form.amount_id.value=piece.addon_price*this.value;
          this.form.tax_id.value=piece.tax*this.value;"><br /><span class="tiny">Quantity</span></td>

<td><input type="text" class="input-res" size="30%" id="source_id" name="source"><br /><span class="tiny">Entry source</span></td>
<td><input type="text" class="input-res" size="30%" id="pnotes_id" name="pnotes"><br /><span class="tiny">Notes</span></td>
<td align="right">
	<input type="hidden" id="addon_desc_link_id" name="addon_desc_link">
	<input type="hidden" id="addon_key_id" name="addon_key" value="NULL">
	<input type="hidden" id="addon_pointer_id" name="addon_pointer" value="NULL">
	<input type="text" class="input-res" size="10%" id="amount_id" name="amount"><br /><span class="tiny">Amount</span></td>
	<td align="right">
	<input type="text" class="input-res" size="10%" id="tax_id" name="tax"><br /><span class="tiny">Tax</span>
</td>
<td><input type="image" src="/images/sm_add.png" onclick="this.form.amount_id.value=this.form.amount.value;this.form.tax_id.value=this.form.tax.value;this.form.submit;"></td></tr>
STUFF;
require_once "{$_SERVER['DOCUMENT_ROOT']}/lib/addonutils.php";
print '<tr><td colspan="2" class="bold right">Add-on Assistant</td><td colspan="3">';
$items = get_addon_list_hierarchical();	//	Lives in registration form code. Empty
									//	parameter means retrieve all addons.
// foreach ($items as $this_item => $item) {
//  	print "<br />Item: "; print_r($item);
//  	$temp_j = json_encode($item);
//  	print "<br />$temp_j</br />";
// }
print '<select name="addon_select" id="addon_entry_type" onChange="update_posting(this.value)">';
print '<option value="">Please select an add-on, adjust quantity and post...</option>';

	$this_type = '';
	$printing_id = '';
	foreach ($items as $this_item => $item) {
/*
	Process parent (or only) record
*/
		if ($item['p_addon_id']) {
			$thing = array();
			foreach ($item as $this_element => $element) {
				if (substr($this_element, 0, 1) == "p") {	//	Parent elements only
					$thing[substr($this_element, 2)] = $element;
				}
				$j_value = urlencode(json_encode($thing));
			}
			print "<option value=\"$j_value\">{$item['p_addon_name']}</option>
			";
		}

/*
	Process child record
*/
		if ($item['c_addon_id']) {	//Is this a child?
			$thing = array();
			foreach ($item as $this_element => $element) {
				if (substr($this_element, 0, 1) == "c") {	//	Child elements only
					$thing[substr($this_element, 2)] = $element;
				}
				$j_value = urlencode(json_encode($thing));
			}
			print "<option value=\"$j_value\">&nbsp;&nbsp;&bullet;&nbsp;{$item['c_addon_name']}</option>
			";

		}
		$printing_id = $item['p_addon_id'];
	}
print '</select>';
$balance = round($balance, 2);
$tax_balance = round($tax_balance, 2);
$total_balance = $balance+$tax_balance;
//	Set index for $total_balance status. Increment by 1 as <=> returns -1, 0, +1
$balance_status = ($total_balance <=> 0) + 1;
$msg = ['<div class="warning" style="color:#00AA00">CREDIT OWING</div>', '<div class="transaction bold">PAID IN FULL</div>', '<div class="warning">BALANCE DUE AT CHECKIN</div>'][$balance_status];
print "<tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td><td>&nbsp;</td><td colspan=\"2\">$msg</td><td nowrap class=\"transaction right bold\">".sprintf("$%.2f", $total_balance)."</td></tr>";
/* Adjust acct_status to reflect balance state. */


$statusmsg = ['Credit Owing', 'Paid', 'Balance Due'][$balance_status];
$sql = "UPDATE {$db['tb2']} SET acct_status = '$statusmsg' WHERE confirmation_no=$confirmation_no";
	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to update Account Balance status. Sorry!');

print '</table>';
print '</form>';
mysql_logout();	//	Disconnect from database

	print "<script type=\"text/javascript\">$(\"#reg_status\").html(\"$statusmsg\");
	</script>";
?>