<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 23 November, 2017
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /manager/help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');

/* MySQL table names */

$db['tb'] = 'regpresenterall_history r';
$db['tbnoalias'] = 'regpresenterall_history';

global $opts;

/* Field definitions start here */

$fields['action'] = array(
		'heading' => "Database Action",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*, Master',
		'filter' => "");
$fields['revision'] = array(
		'heading' => "Revision",
		'primarykey' => true,
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*, Master',
		'filter' => "");
$fields['dt_datetime'] = array(
		'heading' => "Change Time",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*, Master',
		'format' => '%d%b%Y %T',
		'filter' => "");
$fields['timestamp'] = array(
		'heading' => "Time Stamp",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*',
		'format' => '%d%b%Y %T',
		'helpfile' => 'help/timestamphelp.php',
		'filter' => "");
$fields['confirmation_no'] = array(
		'heading' => "Registration No.",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Master, *',
		'filter' => "");
$fields['confirmation_no'] = array(
		'heading' => "Registration No.",
		'table' => 'r',
		'fieldgroup' => 'Master, *',
		'display' => true,
		'filter' => "");
$fields['bus_name'] = array(
		'heading' => "Presentation Name",
		'fieldgroup' => 'Master, *, Copy',
		'table' => 'r',
		'display' => true,
		'filter' => "");
$fields['resourceroom'] = array(
		'heading' => "Room Assigned",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Presenter, Slide, Copy',
		'allowedvalues' => array('', 'Olympic', 'Juan de Fuca', 'Peninsula',
			'Hotel Lounge', 'Hollywood Beach', 'SO Lounge', 'Rm 147', 'Rm 150',
			'Rm 151', 'Rm 152', 'Rm 153', 'Rm 154', 'Rm 155', 'Rm 156',
			'Rm 157', 'Rm 159', 'Esprit Lobby', 'All-Day Event', 'Midday Event',
			'Evening Event', 'Elks Ballroom', 'Elks Pool Room',
			'Elks Lodge Room', 'Off-site', 'Other'),
		'allowedlabels' => array('None', 'Olympic', 'Juan de Fuca', 'Peninsula',
			'Hotel Lounge', 'Hollywood Beach', 'SO Lounge', 'Rm 147', 'Rm 150',
			'Rm 151', 'Rm 152', 'Rm 153', 'Rm 154', 'Rm 155', 'Rm 156',
			'Rm 157', 'Rm 159', 'Esprit Lobby', 'All-Day Event', 'Midday Event',
			'Evening Event', 'Elks Ballroom', 'Elks Pool Room',
			'Elks Lodge Room', 'Off-site', 'Other'),
		'arrayedit' => true,
		'widget' => 'menu',
		'filter' => "");
$fields['resourcedate'] = array(
		'heading' => "Date Scheduled",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Master, Presenter, Slide, Copy',
		'arrayedit' => true,
		'widget' => 'datetimepicker',
		'type' => 'date',
		'format' => 'dMY h:iA',
		'filter' => "");
$fields['resourceduration'] = array(
		'heading' => "Duration",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Presenter, Slide, Ticket, AddNew, Preview, TicketPreview',
		'allowedvalues' => array('', '30', '60', '90', '120', '180', '240',
			'300', '360', '420', '480', '540'),
		'allowedlabels' => array('none', '30 min.', '1 hr', '1.5 hr', '2 hr',
			'3 hr', '4 hr', '5 hr', '6 hr', '7 hr', '8 hr', '9 hr'),
		'arrayedit' => true,
		'widget' => 'menu',
		'filter' => "");
$fields['resourcestatus'] = array(
		'heading' => "Status",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Presenter, Slide, Ticket, Preview, TicketPreview',
		'arrayedit' => true,
		'widget' => 'menu',
		'search_more' => true,
		'allowedvalues' => array('', 'Inquiry', 'Approved', 'Scheduled',
			'Co-Presenter', 'Cancelled'),
		'allowedlabels' => array('None', 'Inquiry', 'Approved', 'Scheduled',
			'Co-Presenter', 'Cancelled'),
		'filter' => "");
$fields['resourceformat'] = array(
		'heading' => "Format",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Presenter, Slide, Ticket, Preview, TicketPreview',
		'arrayedit' => true,
		'widget' => 'menu',
		'search_more' => true,
		'allowedvalues' => array('', 'Class', 'Workshop', 'Event', 'Ticketed', 'Excursion',
			'Service'),
		'allowedlabels' => array('', 'Class', 'Workshop', 'Event', 'Ticketed', 'Excursion',
			'Service'),
		'filter' => "");

$fields['bus_desc'] = array(
		'heading' => "Business Description",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, Copy',
		'search_more' => true,
		'filter' => "");
$fields['resourcebio'] = array(
		'heading' => "Biography",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, Copy',
		'search_more' => true,
		'filter' => "");
$fields['flyer'] = array(
		'heading' => "Flyer/Coupon",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, Copy',
		'search_more' => true,
		'filter' => "");

/* AV requirements for presentations */

$fields['seating'] = array(
		'heading' => "Seating Arrangement",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Copy',
		'search_more' => true,
		'filter' => "");
$fields['avproj'] = array(
		'heading' => "Computer Projector",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Copy',
		'search_more' => true,
		'filter' => "");
$fields['avslideproj'] = array(
		'heading' => "Slide Projector",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Copy',
		'search_more' => true,
		'filter' => "");
$fields['avscreen'] = array(
		'heading' => "Screen",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Copy',
		'search_more' => true,
		'filter' => "");
$fields['avcd'] = array(
		'heading' => "CD Player",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Copy',
		'search_more' => true,
		'filter' => "");
$fields['avdvd'] = array(
		'heading' => "DVD Player",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Copy',
		'search_more' => true,
		'filter' => "");
$fields['avvcr'] = array(
		'heading' => "VCR Player",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Copy',
		'search_more' => true,
		'filter' => "");
$fields['avoverhead'] = array(
		'heading' => "Overhead Projector",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Copy',
		'search_more' => true,
		'filter' => "");
$fields['avmic'] = array(
		'heading' => "Microphone",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Copy',
		'search_more' => true,
		'filter' => "");
$fields['avpodium'] = array(
		'heading' => "Podium",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Copy',
		'search_more' => true,
		'filter' => "");
$fields['avmonitor'] = array(
		'heading' => "TV Monitor",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Copy',
		'search_more' => true,
		'filter' => "");
$fields['avpiano'] = array(
		'heading' => "Piano",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Copy',
		'search_more' => true,
		'filter' => "");
$fields['resourcenotes'] = array(
		'heading' => "Notes",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, Copy',
		'search_more' => true,
		'filter' => "");
$fields['flyer'] = array(
		'heading' => "Flyer/Coupon",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Copy',

		'search_more' => true,
		'filter' => "");

/* End of special setup requirements */

/*	Fields for Slide generation */

$fields['slide_notes'] = array(
		'heading' => "Slide Notes",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, Copy',
		'search_more' => true,
		'filter' => "");
$fields['slide_startdisplay'] = array(
		'heading' => "Start Slide Display",
		'table' => 'r',
		'fieldgroup' => 'Presenter, Slide, Copy',
		'arrayedit' => true,
		'select' => true,
		'widget' => 'datetimepicker',
		'type' => 'date',
		'format' => 'dMY h:iA',
		'search_more' => true,
		'filter' => "");
$fields['slide_image'] = array(
		'heading' => "Slide Image",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, Copy',
		'search_more' => true,
		'filter' => "");
$fields['slide_bgimage'] = array(
		'heading' => "Slide Background Image",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, Copy',
		'search_more' => true,
		'filter' => "");
$fields['slide_font'] = array(
		'heading' => "Slide Font",
		'table' => 'r',
		'select' => true,
		'allowedvalues' => array('',
			'Aguafina',
			'Airstream',
			'Arizonia',
			'Bubblegum',
			'Calligraphica',
			'Calligraphica2Rg',
			'CalligraphicaLight',
			'CevicheOne',
			'Champagne',
			'ChampagneSmall',
			'ChunkFive',
			'Coda',
			'GreatVibes',
			'HennyPenny',
			'JungleFever',
			'KaushanScript',
			'Kitchenpolice',
			'Limelight',
			'Lobster13',
			'Mothproof',
			'PleasantlyPlump',
			'PoetsenOne',
			'PorterSans',
			'Qumpellkano',
			'Redressed',
			'SeasideResort',
			'SofaDione',
			'Titan_one',
			'Tradewinds',
			'TwentyDb',
			'Vanilla',
			'Wideawake',
			'WideawakeBlack',
			'Windsong',
			'Slideonly'
		),
		'fieldgroup' => 'Presenter, Slide, AddNew, Preview',
		'search_more' => true,
		'filter' => "");
$fields['slide_title_font_size'] = array(
		'heading' => 'Title Font Size',
		'table' => 's',
		'select' => true,
		'allowedvalues' => array('',
			'60',
			'72',
			'84',
			'96',
			'120',
			'144'
		),
		'fieldgroup' => 'Presenter, Slide, Preview',
		'search_more' => true,
		'filter' => "");
$fields['slide_textcolour'] = array(
		'heading' => "Slide Text Colour",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, Copy',
		'search_more' => true,
		'filter' => "");
$fields['slide_format'] = array(
		'heading' => "Slide Format",
		'table' => 'r',
		'select' => true,
		'allowedvalues' => get_slide_styles('css/slide_styles'),
		'fieldgroup' => 'Presenter, Slide, AddNew, Preview',
		'search_more' => true,
		'filter' => "");

/*	End of Slide fields */

/*	Fields for Ticket generation */

$fields['ticket_image'] = array(
		'heading' => "Ticket Image",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Ticket, AddNew, TicketPreview',
		'search_more' => true,
		'filter' => "");
$fields['ticket_bgimage'] = array(
		'heading' => "Ticket Background Image",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Ticket, AddNew, TicketPreview',
		'search_more' => true,
		'filter' => "");
$fields['ticket_font'] = array(
		'heading' => "Ticket Font",
		'table' => 's',
		'select' => true,
		'allowedvalues' => array('',
			'Aguafina',
			'Airstream',
			'Arizonia',
			'Bubblegum',
			'Calligraphica',
			'Calligraphica2Rg',
			'CalligraphicaLight',
			'CevicheOne',
			'Champagne',
			'ChampagneSmall',
			'ChunkFive',
			'Coda',
			'GreatVibes',
			'HennyPenny',
			'JungleFever',
			'KaushanScript',
			'Kitchenpolice',
			'Limelight',
			'Lobster13',
			'Mothproof',
			'PleasantlyPlump',
			'PoetsenOne',
			'PorterSans',
			'Qumpellkano',
			'Redressed',
			'SeasideResort',
			'SofaDione',
			'Titan_One',
			'Tradewinds',
			'TwentyDb',
			'Vanilla',
			'Wideawake',
			'WideawakeBlack',
			'Windsong',
			'Slideonly'
		),
		'fieldgroup' => 'Presenter, Ticket, AddNew, TicketPreview',
		'search_more' => true,
		'filter' => "");
$fields['ticket_title_font_size'] = array(
		'heading' => 'Title Font Size',
		'table' => 's',
		'select' => true,
		'allowedvalues' => array('',
			'16',
			'18',
			'24',
			'36',
			'60',
			'72'
		),
		'fieldgroup' => 'Presenter, Ticket, AddNew, TicketPreview',
		'search_more' => true,
		'filter' => "");
$fields['ticket_textcolour'] = array(
		'heading' => "ticket Text Colour",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Ticket, AddNew, TicketPreview',
		'search_more' => true,
		'filter' => "");
$fields['ticket_format'] = array(
		'heading' => "Ticket Format",
		'table' => 's',
		'select' => true,
		'allowedvalues' => get_slide_styles('css/ticket_styles'),
		'fieldgroup' => 'Presenter, Ticket, AddNew, TicketPreview',
		'search_more' => true,
		'filter' => "");

/*	End of Ticket fields */

/*	Other fields */

$fields['specialrequests'] = array(
		'heading' => "Special Requests",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, Ticket, AddNew',
		'search_more' => true,
		'filter' => "");
$fields['esprit_year'] = array(
		'heading' => "Esprit Year",
		'table' => 'r',
		'select' => true,
		'search_more' => true,
		'fieldgroup' => 'Master, *, Copy',
		'filter' => "");
$fields['reg_count'] = array(
		'heading' => "Attendance",
		'table' => 'r',
		'select' => true,
		'search_more' => true,
		'fieldgroup' => 'Master, Presenter, AddNew',
		'filter' => "");
$fields['attendees'] = array(
		'heading' => "Attendees",
		'table' => 's',
		'fieldgroup' => '*, Presenter, AddNew',
		'search_more' => true,
		'filter' => "");
$fields['id'] = array(
		'heading' => "Record ID",
		'table' => 's',
		'primarykey' => true,
		'fieldgroup' => '*, Master, AddNew',
		'search_more' => true,
		'filter' => "");

/* End of Field definitions. */

/* Field group definitions */

$tpl['fieldgroups'] = array(
	'Master' => array('label'=>'Master',
		'url' =>''),
/*	No tabs except All Fields for history.
	'Presenter' => array('label' => 'Presentation',
		'url' => 'presenterurl.php',
		'authgroup' => array('Registrar', 'Desk', 'Presenter', 'Admin')),
	'Slide' => array('label' => 'Slide',
		'url' => 'presenter_pp_url.php',
		'authgroup' => array('Admin', 'Presenter')),
	'Preview' => array('label' => 'Slide Preview',
		'url' => 'presenter_slide_url.php',
		'authgroup' => array('Admin', 'Presenter')),
	'Ticket' => array('label' => 'Ticket',
		'url' => 'presenter_ticket_design_url.php',
		'authgroup' => array('Admin', 'Presenter')),
	'TicketPreview' => array('label' => 'Ticket Preview',
		'url' => 'presenter_ticket_preview_url.php',
		'authgroup' => array('Admin', 'Presenter')),
*/
/*
	Following tab is disabled until there's a standard way to encode
	date and event information in QR codes.
*/
	'All' => array('label' => 'All Fields',
		'url' => 'allfieldsurl.php?dirname=presentershistory',
		'authgroup' => array('Admin')),
/*	No tabs except All Fields for history.
	'AddNew' => array('label' => ' + ',
		'url' => 'presenter_addurl.php?group=AddNew',
		'authgroup' => array('Registrar', 'Presenter', 'Admin'),
		'scroll' => 'No'	//	Prevent scrolling to this screen
		),
	'Delete' => array('label' => 'Delete',
		'url' => 'presentation_delete.php?group=AddNew',
		'authgroup' => array('Registrar', 'Presenter', 'Admin'),
		'scroll' => 'No'	//	Prevent scrolling to this screen
		)
*/
);
function get_slide_styles($dir) {
	$files = scandir($dir);
	if (!$files) {		//	Directory exists?
		$result[] = "No styles directory $dir";
		return $result;
	}
	natcasesort($files);
	foreach ($files as $f) {
		if (strtolower(strrchr($f, '.')) == '.css') {
			$result[] = $f;		//	Ignore anything not css
		}
	}
	if (!isset($result)) {	//	Any contents?
		$result[] = "Empty styles directory $dir";
	}
	return $result;
}
?>