<?php
/*
	See if logged in via Quadodo
*/

define('QUADODO_IN_SYSTEM', true);
require_once 'qls/includes/header.php';
$tpl['authgroup'] = $qls->group_id_to_name($qls->user_info['group_id']);
$tpl['username'] = $qls->user_info['username'];
if ($tpl['username'] == '') {
header('Location: qls/login.php');
exit;
}
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once 'mysql_utilities.php';
require_once ".config.php";

/* Highslide code */

$format = (isset($_REQUEST['format']) ? $_REQUEST['format'] : '');
// print 'Today: '.strftime('%F %T', $today).'<br />';	// uncomment for testing
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<title>Esprit Rate Table</title>
<script src="lib/js/jquery.js"></script>
<script src="lib/js/jquery-ui.js"></script>
<script src="lib/js/jquerymobile.js"></script>
<script src="lib/js/highslide/highslide-full.js"></script>
<script src="lib/js/highslide/highslide-config_noslide.js"></script>
<link href="css/styles.css" rel="stylesheet" type="text/css" />
<link href="lib/js/highslide/highslide.css" rel="stylesheet" type="text/css" />
<link href="css/highslide/highslide-overrides.css" rel="stylesheet" type="text/css" />
<link href="css/presenter-theme/jquery-ui.css" rel="stylesheet" type="text/css" />
<style>
.label, .value { font-weight: normal; }
body {
	font-family: "Palatino";
	font-size: 10pt;
	background-color: #FFEEEE;
	padding: 6px;
}
.mono {
	font-family: "Lucida Console", "Courier New", Courier, monospace;
	font-size: 9pt;
	padding: 0px 6px 0px 6px;
}
</style>
<script>
$(function() {
$( "#picker" ).datepicker({
	changeMonth: true,
	changeYear: true,
	minDate: new Date(<?php print $esprit_year-1;?>, 10, 01),
	maxDate: new Date(<?php print $esprit_year?>, 5, 01),
	showOn: "button",
	buttonImage: "images/calendar.gif",
	buttonImageOnly: true,
	buttonText: "Select date",
	showButtonPanel: true });
});
</script>
</head>

<?php

global $mealnames;

print "
<body>
<form action=\"ratetable.php\" method=\"get\" name=\"form1\" id=\"formID\">";
print "<input type=\"radio\" name=\"format\" value=\"Full\" onChange=\"submit();\"";
if ($format=='Full') {
	print ' checked=""';
}
print "/>Full";
print "<input type=\"radio\" name=\"format\" value=\"Print\" onChange=\"submit();\"";
if ($format=='Print') {
	print ' checked=""';
}
print "/>Print";
print "<input type=\"radio\" name=\"format\" value=\"Online\" onChange=\"submit();\"";
if ($format=='Online') {
	print ' checked=""';
}
print "/>Online";
print "<h1>Esprit $esprit_year ";
if (TESTING) {
	print "SAMPLE ";
}
	for ($tier_no = 1 ; $tier_no <= 6 ; $tier_no++) {
		if ($check['rate_tier'][$tier_no] == 1) {
			$this_tier = $tier_no;
			break;
		};
	}
	if ($this_tier == 0) {
		SM_Die("Invalid tier number $this_tier in ratetable!", 'Internal error - invalid tier number in rate table - sorry!');
	}
require_once "mysql_utilities.php";
mysql_login('Read-only');

$sql = "SELECT CONCAT(mt_weekday, mt_mealtime) mcode, mt_cost mprice
	FROM regmealtypes";
$sql_meals = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error while retrieving meal costs: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Internal error - unable to retrieve meal cost data - sorry!');
$mealcosts = array();
while ($mcost = mysqli_fetch_assoc($sql_meals)) {
	$mealcosts[$mcost['mcode']] = $mcost['mprice'];
}

$sql = "SELECT addon_price mpkg
	FROM regaddons
	WHERE addon_name LIKE 'Full Week Meal%'";
$sql_mpkg = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error while retrieving meal package price: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Internal error - unable to retrieve meal package price - sorry!');
$mpkg = mysqli_fetch_assoc($sql_mpkg)['mpkg'];

$sql = "SELECT *
	FROM regpackages ";
switch ($format) {
case 'Print':
	$sql .= "WHERE pkg_tier=$this_tier
				AND pkg_type='Full Rate'";
	break;
case 'Full':
	$sql .= "WHERE pkg_tier=$this_tier ";
	break;
case 'Online':
	$sql .= "WHERE pkg_tier=$this_tier
				AND pkg_type='Online'";
	break;
default:
	$sql .= "WHERE pkg_tier=$this_tier ";
}
$sql .= "
	AND (pkg_available IS NULL
		OR pkg_available = 'Yes')";
$sql .= "	ORDER BY pkg_type,
	CASE
		WHEN pkg_form_type='Single' THEN 1
		WHEN pkg_form_type='SO' THEN 2
		WHEN pkg_form_type='Add_Family' THEN 3
		ELSE pkg_form_type
	END,
	CASE
		WHEN pkg_code LIKE 'SS%' THEN 1
		WHEN pkg_code LIKE 'SS%' THEN 2
		WHEN pkg_code LIKE 'SS%' THEN 3
		ELSE pkg_code
	END	
		";
$sql_result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error while retrieving rate table: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Internal error - unable to retrieve rate table data - sorry!');
while ($row = mysqli_fetch_assoc($sql_result)) {

	//	Combine meals into string
// 	$row['meals'] = ($row['pkg_mealfb'] == 1?'FB ':'-&nbsp;&nbsp;').
	$row['meals'] = ($row['pkg_mealfl'] == 1?'FL ':'-&nbsp;&nbsp;').
	$row['meals'] = ($row['pkg_mealfd'] == 1?'FD ':'-&nbsp;&nbsp;').
	$row['meals'] = ($row['pkg_mealsl'] == 1?'AL ':'-&nbsp;&nbsp;').
	$row['meals'] = ($row['pkg_mealsd'] == 1?'AD ':'-&nbsp;&nbsp;').
	$row['meals'] = ($row['pkg_mealub'] == 1?'UB ':'-&nbsp;&nbsp;');
	
	//	Add up meal costs for sanity check
	$row['mealtot'] = ($row['pkg_mealfl'] == 1?$mealcosts['FL'] :0)
		+ ($row['pkg_mealfd'] == 1?$mealcosts['FD'] :0)
		+ ($row['pkg_mealsl'] == 1?$mealcosts['AL'] :0)
		+ ($row['pkg_mealsd'] == 1?$mealcosts['AD'] :0)
		+ ($row['pkg_mealub'] == 1?$mealcosts['UB'] :0);

	//	If total is greater than package price, use package price
	if ($row['mealtot'] > $mpkg) {
		$row['pkgprice'] = "P";
	} else {
		$row['pkgprice'] = "";
	}

	//	Combine days into string
	$row['days'] = ($row['pkg_days1'] == 1?'Su1 ':'-&nbsp;&nbsp;&nbsp;').
	$row['days'] = ($row['pkg_daym'] == 1?'Mo ':'-&nbsp;&nbsp;').
	$row['days'] = ($row['pkg_dayt'] == 1?'Tu ':'-&nbsp;&nbsp;').
	$row['days'] = ($row['pkg_dayw'] == 1?'We ':'-&nbsp;&nbsp;').
	$row['days'] = ($row['pkg_dayr'] == 1?'Th ':'-&nbsp;&nbsp;').
	$row['days'] = ($row['pkg_dayf'] == 1?'Fr ':'-&nbsp;&nbsp;').
	$row['days'] = ($row['pkg_daya'] == 1?'Sa ':'-&nbsp;&nbsp;').
	$row['days'] = ($row['pkg_days2'] == 1?'Su2':'-&nbsp;&nbsp;');

	$packages[] = $row;
}
mysql_logout();	//	Disconnect from database


print "Rate Table - effective: $today_text <input type=\"hidden\" id=\"picker\" name=\"date\" onChange=\"submit();\" value=\"$today_text\"/></h1>";
print "<input type=\"hidden\" name=\"pko\" value=\"PKO\">
</form>
<p>In Meals: FB=Friday Breakfast, FL=Friday Lunch, FD=Friday Dinner, AL=Saturday Lunch, AD=Saturday Dinner, UB=Sunday Brunch.<br />
In Notes: \"T2\", \"T3\" etc. refer to rate tiers. M>P: meal cost is greater than package cost</p>
<table style=\"width:75em\">
<tr>
	<td class=\"bold\">Rate Group</td>
	<td class=\"bold\">Rate Type</td>
	<td class=\"bold\">Code</td>
	<td class=\"bold\" align=\"right\">Rate&nbsp;</td>
	<td class=\"bold\">Days</td>
	<td class=\"bold\">Meals</td>
	<td class=\"bold\" align=\"right\">Meal Cost&nbsp;</td>
	<td class=\"bold\">Pkg?</td>
	<td class=\"bold\">Notes</td>
</tr>";
$prevpackage = array();
foreach ($packages as $thispackage => $package) {
	$print_pkg_type = @($prevpackage['pkg_type'] == $package['pkg_type']) ? '' : $package['pkg_type'];
	$print_pkg_form_type = @($prevpackage['pkg_form_type'] == $package['pkg_form_type']) ? '' : $package['pkg_form_type'];
	$notes = strip_tags($package['pkg_notes'], '<a><h1><h2><h3><h4>');
	print "<tr>
		<td>$print_pkg_type</td>
		<td>$print_pkg_form_type</td>
		<td>{$package['pkg_code']}</td>
		<td align=\"right\">{$package['pkg_rate']}&nbsp;</td>
		<td class=\"mono\">{$package['days']}</td>
		<td class=\"mono\">{$package['meals']}</td>
		<td align=\"right\">\${$package['mealtot']}&nbsp;</td>
		<td align=\"right\">{$package['pkgprice']}&nbsp;</td>
		<td>$notes";
	if ($package['mealtot'] > ($package['pkg_rate'] + .01)) {
		print " <b>** M>P **</b>";
	}
	print "</td>
	</tr>";

	$prevpackage = $package;

}
print "</table>";
?>
</body>
</html>

