<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 23 November, 2017
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');
global $opts, $all_years;

/* MySQL table names */

$db['tb'] = 'regcontrol r';
$db['tbnoalias'] = 'regcontrol';
$opts['join_clause'] = '';

/* Field definitions start here */

$fields['created'] = [
		'heading' => "Created",
		'table' => 'r',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'width' => '15%',
		'css' => 'font-size:80%',
		'search_more' => true,
		'width' => '15%',
		'fieldgroup' =>  'Master, Detail',	//	No copy to new
		'filter' => ""];
$fields['updated'] = [
		'heading' => "Updated",
		'table' => 'r',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'width' => '15%',
		'css' => 'font-size:80%',
		'search_more' => true,
		'width' => '15%',
		'fieldgroup' =>  'Master, Detail',	//	No copy to new
		'filter' => ""];
$fields['category'] = [
		'heading' => "Category",
		'table' => 'r',
		'display' => true,
		'width' => '20%',
		'arrayedit' => true,
		'widget' => 'menu',
		'allowedvalues' => ['',
			'Blacklist',
			'Committee_Full',
			'Committee_Partial',
			'Committee_Disabled',
			'Special_Rate'],
		'fieldgroup' =>  'Master, Detail',
		'filter' => ""];
$fields['privileges'] = [
		'heading' => "Privileges",
		'table' => 'r',
		'display' => true,
		'width' => '20%',
		'arrayedit' => true,
		'widget' => 'menu',
		'allowedvalues' => ['',
			'Badge_Control:Admin',
			'Badge_Control:Meals',
			'Badge_Control:Events',
			'Special_30'],
		'fieldgroup' =>  'Master, Detail',
		'filter' => ""];
$fields['email'] = [
		'heading' => "Email",
		'table' => 'r',
		'display' => true,
		'width' => '20%',
		'arrayedit' => true,
		'fieldgroup' =>  'Master, Detail',
		'filter' => ""];
$fields['scannername'] = [
		'heading' => "Scanner Name",
		'table' => 'r',
		'display' => true,
		'width' => '20%',
		'arrayedit' => true,
		'fieldgroup' =>  'Master, Detail',
		'filter' => ""];
$fields['comment'] = [
		'heading' => "Comment",
		'table' => 'r',
		'display' => true,
		'width' => '30%',
		'arrayedit' => true,
		'widget' => 'ckeditor',
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['id'] = [
'heading' => 'Entry number',
		'primarykey' => true,
		'table' => 'r',
		'search_more' => true,
		'fieldgroup' => '*',
		'filter' => ""];

/* End of Field definitions. */

/* Field group definitions */

$tpl['fieldgroups'] = [
/*	'Blank' => ['label' => '>',
		'url' => 'blank.php'], */
	'Master' => ['label'=>'Master',
		'url' =>''],
	'Detail' => ['label' => 'Details',
		'url' => 'taburl.php?template=regcontrol_detail.tpl',
		'height' => '400',
		'authgroup' => ['Admin', 'Registrar']],
	'AddNew' => ['label' => 'Copy',
		'url' => 'add.php',
		'authgroup' => ['Admin', 'Registrar'],
		'scroll' => 'No'	//	Prevent scrolling to this screen
	],
	'Logs' => ['label' => 'Log Entries',
		'url' => "../log-list.php?tbname={$db['tbnoalias']}",
		'width' => 1500,
		'height' => 800,
		'authgroup' => ['Admin']],
	'DeleteThis' => ['label' => 'Delete',
		'url' => 'delete.php',
		'authgroup' => ['Admin', 'Registrar'],
		'scroll' => 'No'	//	Prevent scrolling to this screen
		]
];

?>