<?php
/*
	Esprit Chart System, by Stephanie Mitchell
	4 December, 2017
	
	An application for generating charts from data gathered during Esprit online
	registrations.
	This version creates multiple charts on the same page for an overview of the
	current year.
	
	This application uses FusionCharts, a Javascript charting package.
	
*/
$committee = (isset($_REQUEST['password']) ? $_REQUEST['password'] : false);
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once 'mysql_utilities.php';
require_once ".regconnect.php"; // hostname, ID and password
define('QUADODO_IN_SYSTEM', true);
require_once ".config.php";
$committee_login = ($committee == $committee_override);
if (TESTING) { $test_msg = 'TEST';}
$chart_year = isset($_REQUEST['chart_year']) ? $_REQUEST['chart_year'] : $esprit_year;
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<?php print "<title>Esprit $chart_year Online Scholarship Charts $test_msg</title>";?>
<link href="../../lib/css/styles.css" rel="stylesheet" type="text/css" />
<script language="javascript" src="/lib/js/jquery.js"></script>
<script type="text/javascript" src="/lib/js/jquery-ui.js"></script>
<script type="text/javascript" src="/lib/js/jquerymobile.js"></script>

<!-- Highslide code -->
<script type="text/javascript" src="/lib/js/highslide/highslide-full.js"></script>
<!-- 
<script type="text/javascript" src="/lib/js/highslide/mobile.js"></script>
 -->
<script type="text/javascript" src="highslide-config.js"></script>
<link href="/lib/css/styles.css" rel="stylesheet" type="text/css" />
<link rel="stylesheet" type="text/css" href="/lib/js/highslide/highslide.css">
<style type="text/css">
.highslide-wrapper .highslide-html-content {
    width: auto;
    height: auto;
    overflow: scroll;
}
.hidden {
	display: none;
}
</style>
<script>
	/*	Fix highslide graphic directory */
	hs.graphicsDir = '/lib/js/' + hs.graphicsDir;
</script>
</head>

<body>
<?php

mysql_login('Read-only');

	$sql = "SELECT DISTINCT esprit_year
	FROM regall
	ORDER BY esprit_year DESC;";

	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.': Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);
?>
<div style="width:900px" >
	<p><a name="top" id="top"></a><img src="/images/logo.gif" alt="Esprit Logo" width="420" height="90" /></p>
	<h2>Esprit <?php print $chart_year;?> Scholarship Statistics Charts</h2>
	<p>Here are several charts and graphs about scholarship applications at Esprit <?php print $chart_year;?>. You may have to scroll down to see them all.</p>
	<p>Roll over various items for clarification. You may have to empty your browser's cache if the charts look out of date.</p>
	<p>Charts for <?php print $esprit_year;?> are up-to the minute. Other years are drawn from historical data.</p>
		<?php if (TESTING) { print '<p class="errormsg">NOTE - Registration system is in TEST mode. These charts show TEST DATA ONLY.</p>';} ?>
	<form id="form1" name="form1" method="post" action="indexschols.php" class="noprint">
		Select a year:
		<select name="chart_year" id="chart_year" onchange="this.form.submit();">
			<?php while ($row = mysqli_fetch_array($result)) {	// collect years for dropdown
	print "<option";
	if ($chart_year == $row['esprit_year']) {
		print ' selected="selected"';
	}
	print ">".$row['esprit_year']."</option>\n";
}
mysql_logout();	//	Disconnect from database

?>
		</select>
	</form>
	
<?php

/*	Charts */

print <<< CHARTS

<div><a href="scholarships_by_day.php?chart_year=$chart_year" onclick="return hs.htmlExpand(this, { objectType: 'iframe',slideshowGroup: 'charts',width: 1000, height: 600} )" title=" ">Show Charts</a></div>

<div class="hidden"><a href="scholarships_by_month.php?chart_year=$chart_year" onclick="return hs.htmlExpand(this, { objectType: 'iframe',slideshowGroup: 'charts',width: 1000, height: 600} )" title=" ">Schols by Month</a></div>

<div class="hidden"><a href="scholarships_by_type.php?chart_year=$chart_year" onclick="return hs.htmlExpand(this, { objectType: 'iframe',slideshowGroup: 'charts',width: 1000, height: 600})" title=" ">Schols by Status</a></div>

<div class="hidden"><a href="scholarships_by_year_amount.php?chart_year=$chart_year" onclick="return hs.htmlExpand(this, { objectType: 'iframe',slideshowGroup: 'charts',width: 1000, height: 600})" title=" ">Schols by Amount</a></div>
CHARTS;
?>
<!-- For reference while building other charts -->
<!--
<script type="text/javascript">
jQuery(document).ready(function(){
    $("#regs_by_where_world").insertFusionCharts({
		type: "maps/worldwithcountries",
		theme: "esprit",
		width: "1200",
		height: "600",
		dataFormat: "XMLURL",
		dataSource: "regs_by_where_world.php?chart_year=$chart_year"
    });

});
</script>
-->

</body>
</html>
