<?php
/*
	Esprit Chart System, by Stephanie Mitchell
	23 January, 2013
	
	This file creates the Registrations by Repeat Visits Chart for the current year overview.
	It is called by one of the Flash calls in index.php.
*/
// Database access

require_once "{$_SERVER['DOCUMENT_ROOT']}/lib/.auth/.regconnect.php"; // hostname, ID and password
define('QUADODO_IN_SYSTEM', true);
require_once "{$_SERVER['DOCUMENT_ROOT']}/lib/.auth/.config.php";
require_once "{$_SERVER['DOCUMENT_ROOT']}/lib/mysql_utilities.php";
// 	ini_set('display_startup_errors',1);
// 	ini_set('display_errors',1);
	error_reporting(-1);		//	All errors
$chart_year = $_REQUEST['chart_year'];
mysql_login('Read-only');

$sql = 'SELECT firstyear,lastyear,cemail times_attended,
		count(cemail) num_of_people
	FROM (SELECT CONCAT(`firstnamepref`,`lastnamepref`) ident,
			min(esprit_year) firstyear, max(esprit_year) lastyear,
			count(email) cemail
		FROM regall
		GROUP BY ident) s
	GROUP BY lastyear, cemail';

	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.': Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);

$count_shown = 0;
// Get all the rows
while ($row = mysqli_fetch_array($result)) {
	$data[] = $row;
	$count_shown++;
//	print "{$row['firstyear']} {$row['times_attended']} {$row['num_of_people']}; ";
}

/*	Walk results. Extract unique years into $years, other data into positional
	arrays for each year. */
$year = '';
$years = '';
$yearstring = '';
/*	Highest number of visits (so we can draw empty slots as required) */
$maxta = 0;	
foreach ($data as $row_key => $this_row) {
	$fy = (string)$this_row['lastyear'];
	$ta = (int)$this_row['times_attended'];
	$np = (int)$this_row['num_of_people'];
	$years = array();
	if ($year != $fy) {
		$years[] = $fy;
	}
	$year = $fy;

		/*	Extract frequency of visits as index of array and no. of people who
			visited that number of times as content. */
		
		$yeardata[$fy][$ta] = $np;
		$maxta = max($maxta, $ta);
}

/*	Initialise chart */
	
print '<chart>
   <license>LTAQS31G3HKOLVE5CWK-2XOI1X0-7L</license>   
   <chart_data>
';
print '<row>
	<null/>
';
/*	Create list of years */
for ($i = 1; $i < $maxta; $i++) {
	print "<string>$i</string>
";
}
print '</row>
';

/* Process each year. We have each year in an associative array element. Each
	such element is a positional array of frequency of visits and the number of
	people who visited that many times. */
foreach ($yeardata as $data_key => $data) {
	print "<row>
	<string>$data_key</string>
";
	for ($i = 1; $i < $maxta; $i++) {
		$val = $data[$i];
		print "<number tooltip='$data_key was Esprit #$i for $val people'>$val</number>
";
	}
	print '</row>
';
}
print '</chart_data>
';
/*	Compute chart labels so we can add an axis label. XML/SWF Charts doesn't
	provide for axis labelling directly so we create a multi-line label halfway
	across. But that means we have to generate all the axis labels. */
$axis_category_label = "<axis_category_label>\n";
for ($i = 1; $i < $maxta; $i++) {
	if ($i == round($maxta / 2, 0)) {
		$axis_category_label .= "<string>$i\rRepeat Visits</string>\n";
	}else {
		$axis_category_label .= "<string>$i</string>\n";
	}
}
$axis_category_label .= "</axis_category_label>\n";
		
print "<chart_grid_h alpha='75' color='AAAAAA' thickness='1' type='solid' />
	<chart_grid_v alpha='75' color='AAAAAA' thickness='1' type='solid' />
	$axis_category_label
	<draw>
		<text x='20' y='10' width='400' height='40' size='12' h_align='center'>Esprit Return Visits</text>
		<text x='33' y='384' size='10' width='35' height='16' color='666666'>Print</text>
		<text x='70' y='384' size='10' width='55' height='16' color='666666'>Fullscreen</text>
	</draw>
	<link>
		<area x='33' y='384' width='35' height='16' target='print' />
		<area x='70' y='384' width='55' height='16' target='toggle_fullscreen' />
	</link>
	<series_color>
		<color>FF3366</color>
		<color>33FF66</color>
		<color>FFFF33</color>
		<color>88FF33</color>
	</series_color>
	<chart_type>parallel 3d column</chart_type>
	<chart_transition type='slide_up' duration='0.5' order='all' />

	
	<legend layout='horizontal' y='40'/>
	<filter>
	</filter>


</chart>";
?>