<?php
/*
	Esprit Chart System, by Stephanie Mitchell
	23 January, 2013
	
	This file creates the Registrations by Length of Stay Chart for the current year overview.
	It is called by one of the Flash calls in index.php.
*/
// Database access

require_once "{$_SERVER['DOCUMENT_ROOT']}/lib/.auth/.regconnect.php"; // hostname, ID and password
define('QUADODO_IN_SYSTEM', true);
require_once "{$_SERVER['DOCUMENT_ROOT']}/lib/.auth/.config.php";
require_once "{$_SERVER['DOCUMENT_ROOT']}/lib/mysql_utilities.php";
$chart_year = $_REQUEST['chart_year'];
mysql_login('Read-only');

$sql = "SELECT count(*) AS c,
		sum(reg_status in (\"Paid\",\"Scholarship\")) AS paid,
		left(ratepkg,2) AS f
	FROM {$db['tb']}
	WHERE reg_status NOT IN (\"Cancelled\", \"DELETED\")
		AND esprit_year=$chart_year
		AND form_type NOT IN (\"Internal\", \"Ticket\")
	GROUP BY left(ratepkg,2)";

$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.': Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);
$count_shown = 0;
$count_total = 0;
// Get all the rows
while ($row = mysqli_fetch_array($result)) {
	$data[$row['f']] = $row;
	$count_shown++;
	$count_total += $row['c'];	// total for computing percentages
//	print_r($row);
}

// Extract package codes from config.php

$packagenames = $packages['Full Rate']['Single'];
$pcount = 0;
foreach ($packagenames as $n => $name) {
	$pkgname[substr($name['code'],0,2)] = $n;
	$pcount++;
}
// print_r($data);

print '<chart>
   <license>LTAQS31G3HKOLVE5CWK-2XOI1X0-7L</license>   
   <chart_data>
';
print '<row>
<null/>
';
foreach ($pkgname as $n => $name) {
	print "<string>$name</string>
";
}
print '</row>
';




/* Process total registrations (outermost) */

$ccount = $pcount;	/*	number of times to display a column. Increases with each
					value to give appearance of varying widths for each category (package) */

foreach ($pkgname as $n => $name) {
	print "<row>
	<string>$name</string>
	";
	for ($nn = 0; $nn < ($pcount -$ccount); $nn++) {
		print '<number>0</number>
		';
	}
	for ($nn = 0; $nn < $ccount; $nn++) {	// display it %ccount times
		$label = $name.'\\r'.$data[$n]['c'];
		$tooltip = 'Total ' . $name.sprintf(' - %u',$data[$n]['c']).sprintf(' (%.1f%%)',round((100*$data[$n]['c']/$count_total),1));
		print "<number shadow='data$n' label=\"$label\" alpha='75' tooltip='$tooltip'>".$data[$n]['c'].'</number>
	';
	}
	$ccount--;	// decrement no. of columns to be displayed
	print "</row>\n";
}




print "</chart_data>
	<chart_grid_h alpha='20' color='FFFFFF' thickness='1' type='solid' />
	<chart_label shadow='low' color='000000' alpha='95' size='10' position='inside' bold='false'/>
	<chart_pref select='true' />
	<chart_rect positive_color='FFFFFF'/>
	<series_color>
		<color>AAFFCC</color>
		<color>FFFFAA</color>
		<color>FF88AA</color>
	</series_color>
	<draw>
		<text x='20' y='10' width='400' height='40' size='11' h_align='center'>Online Registrations by Length of Stay\rEsprit $chartt_year</text>
		<text x='33' y='384' size='10' width='35' height='16' color='666666'>Print</text>
		<text x='70' y='384' size='10' width='55' height='16' color='666666'>Fullscreen</text>
	</draw>
	<link>
		<area x='33' y='384' width='35' height='16' target='print' />
		<area x='70' y='384' width='55' height='16' target='toggle_fullscreen' />
	</link>
	<chart_type>column</chart_type>
	<axis_category alpha='0' />
	<axis_ticks value_ticks='false' category_ticks='false' />
	<series bar_gap='-200' set_gap='0' />
	<legend layout='horizontal' y='40'/>

	<chart_guide horizontal='true' vertical='true' thickness='1' alpha='25' type='dashed' text_h_alpha='100' text_v_alpha='100' text_color='FFFFFF' background_color='888888' />

	<context_menu full_screen='false' />
	<filter>
		<shadow id='low' distance='2' angle='45' color='0' alpha='50' blurX='5' blurY='5' />
		<shadow id='dataSS' angle='90' blurX='0' blurY='64' distance='64' color='AAFFCC' alpha='100' inner='true' knockout='true' type='full' />

		<shadow id='dataWS' angle='90' blurX='0' blurY='32' distance='32' color='FFFFAA' alpha='100' inner='true' knockout='true' type='full' />

		<shadow id='dataFS' angle='90' blurX='0' blurY='16' distance='16' color='FF88AA' alpha='100' inner='true' knockout='true' type='full' />

		<bevel id='shading' angle='-90' blurX='0' blurY='40' distance='10' highlightColor='FFFFFF' highlightAlpha='90' shadowColor='888888' shadowAlpha='90' inner='true' />

	</filter>


</chart>";
?>