<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 23 November, 2017
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');

/* MySQL table names */

$db['tb'] = 'regvenues v';
$db['tbnoalias'] = 'regvenues';

global $opts;
$opts['join_clause'] = '';

/* Field definitions start here */

$fields['venue_created'] = [
		'heading' => "Created",
		'table' => 'v',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'width' => '15%',
		'css' => 'font-size:80%',
		'search_more' => true,
		'width' => '10%',
		'fieldgroup' =>  'Master, Detail',	//	No copy to new
		'filter' => ""];
$fields['venue_updated'] = [
		'heading' => "Updated",
		'table' => 'v',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'width' => '15%',
		'css' => 'font-size:80%',
		'search_more' => true,
		'width' => '10%',
		'fieldgroup' =>  'Master, Detail',	//	No copy to new
		'filter' => ""];
$fields['venue_long'] = [
		'heading' => "Venue Name",
		'table' => 'v',
		'display' => true,
		'width' => '20%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['venue_abbr'] = [
		'heading' => "Abbreviation",
		'table' => 'v',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'copyValue' => 'CREATE UNIQUE ABBR',
		'filter' => ""];
$fields['venue_addr'] = [
		'heading' => "Address",
		'table' => 'v',
		'display' => true,
		'arrayedit' => true,
		'width' => '25%',
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['venue_type'] = [
		'heading' => "Venue Type",
		'table' => 'v',
		'display' => true,
		'arrayedit' => true,
		'width' => '10%',
		'widget' => 'menu',
		'allowedvalues' => ['Onsite Venue', 'Onsite Vendor', 'Offsite Venue', 'Offsite Vendor', 'Online'],
		'fieldgroup' => '*, Master',
		'copyValue' => 'UNASSIGNED',
		'filter' => ""];
$fields['venue_directions'] = [
		'heading' => "Directions",
		'table' => 'v',
		'display' => true,
		'search_more' => true,
		'arrayedit' => true,
		'width' => '1-%',
		'fieldgroup' => '*',
		'filter' => ""];
$fields['venue_maplink'] = [
		'heading' => "Map Link",
		'table' => 'v',
		'display' => true,
		'search_more' => true,
		'arrayedit' => true,
		'widget' => 'menu',
		'allowedvalues' => ['Yes', 'No'],
		'width' => '5%',
		'fieldgroup' =>  'Master, Details',
		'filter' => ""];
$fields['venue_id'] = [
		'heading' => 'Entry number',
		'primarykey' => true,
		'table' => 'v',
		'search_more' => true,
		'fieldgroup' => '*',
		'filter' => ""];

/* End of Field definitions. */

/* Field group definitions */

$tpl['fieldgroups'] = [
/*	'Blank' => ['label' => '>',
		'url' => 'blank.php'], */
	'Master' => ['label'=>'Master',
		'url' =>''
		],
	'Detail' => ['label' => 'Details',
		'url' => 'taburl.php?template=venue_detail.tpl',
		'height' => 700,
		'width' => 1200,
		'authgroup' => ['Admin']
		],
	'AddNew' => ['label' => 'Copy',
		'url' => 'add.php',
		'authgroup' => ['Admin'],
		'scroll' => 'No'	//	Prevent scrolling to this screen
	],
	'DeleteThis' => ['label' => 'Delete',
		'url' => 'delete.php',
		'authgroup' => ['Admin'],
		'scroll' => 'No'	//	Prevent scrolling to this screen
		],
	'Logs' => ['label' => 'Log Entries',
		'url' => "../log-list.php?tbname={$db['tbnoalias']}",
		'width' => 1500,
		'height' => 800,
		'authgroup' => ['Admin']]
];

?>