{* Smarty *}
{*	Produces an editable-in-place array of records. Designed for use within a
	table, it generates a table row for each record. Fields that have
	"arrayedit => true"will be editable in place.
	Also supports widget editing. Fields that have 'widget' => 'widgetname'
	will be presented with a widget such as a calendar popup or a dropdown menu
	instead of a text field. Widget code is generated by smse_widgets.tpl.
	This makes it easy to add new widgets which are then available everywhere.
	Adding a widget requires two changes to the following code:
	1.	Add the jEditable function (copy/paste/modify is easiest) inside the
		$(document).ready(function below.
	2.	Add the corresponding elseif statement towards the end of this code.
	
*}
<script type="text/javascript">var $appname="{$tpl.appname}"</script>
<script type="text/javascript" src="/lib/js/jeditable_setup.js"></script>
<input type="hidden" name="_detail" value="">
{section name=sec1 loop=$data}
{$mydata=$data[sec1]}
<tr class="{cycle values="row-0, row-1"}">
{foreach from=$fields item=thisfield key=thiskey}
	{if $thisfield.display == true}
		{if $thisfield.arrayedit == true}
			{* switch in here if widget requested, otherwise just use plain textarea *}
			{if $thisfield.widget == 'menu'}
				{$class="edit_select arrayeditvalue"}
			{elseif $thisfield.widget == 'checkbox'}
				{$class="checkbox arrayeditvalue"}
			{elseif $thisfield.widget == 'checkboxyn'}
				{$class="checkboxyn arrayeditvalue"}
			{elseif $thisfield.widget == 'datetimepicker'}
				{$class="edit_date arrayeditvalue"}
				{$mydata.$thiskey=$mydata.$thiskey|date_format:'m/d/Y H:i:s'}
			{elseif $thisfield.widget == 'ckeditor'}
				{$class="edit_html arrayeditvalue"}
			{elseif $thisfield.widget == 'textarea'}
				{$class="edit_textarea arrayeditvalue"}
			{elseif $thisfield.widget == 'phonemask'}
				{$class="edit_phone arrayeditvalue"}
			{else}
				{$class="edit"}
			{/if}
			<td class="{$class}" id="{$db.tbnoalias}.{$thiskey}.{$mydata.$primarykeyfield}.{$primarykeyfield}">		
			{if $thisfield.date_format ne ''}
				{$mydata.{$thisfield@key}|date_format:$thisfield.date_format}
			{else}
				{$mydata.$thiskey|trim}{/if}</td>
		{else} {* not array-editable, just display *}
		<td>{if $thisfield.date_format ne ''}
				{$mydata.{$thisfield@key}|date_format:$thisfield.date_format}
			{else}
			{$data[sec1][$thiskey]|regex_replace:"/\[/":"<b>["|regex_replace:"/]/":"]</b>"}
			{/if}</td>
		{/if}
	{/if}
{/foreach}
</tr>
{/section}
