<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 23 November, 2017
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /manager/help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');

/* MySQL table names */

$db['tb'] = 'regtickets t';	// log file
global $opts;
$opts['join_clause'] = '';

/* Field definitions start here */

$fields['timestamp'] = array(
		'heading' => "Time Stamp",
		'table' => 't',
		'display' => true,
		'fieldgroup' => 'Master, *',
		'format' => '%d%b%Y %T',
		'filter' => "");
$fields['item_no'] = array(
		'heading' => "Item No.",
		'table' => 't',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => 'Master, *',
		'filter' => "");
$fields['item_desc'] = array(
		'heading' => "Item Description",
		'table' => 't',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => 'Master, *',
		'colwidth' => '50',
		'filter' => "");
$fields['purchaser_confirmation'] = array(
		'heading' => "Purchaser Confirmation",
		'table' => 't',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => 'Master, *',
		'colwidth' => '50',
		'filter' => "");
$fields['purchased'] = array(
		'heading' => "Qty Purchased",
		'table' => 't',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => 'Master, *',
		'colwidth' => '50',
		'filter' => "");
$fields['redeemed'] = array(
		'heading' => "Qty Redeemed",
		'table' => 't',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => 'Master, *',
		'colwidth' => '50',
		'filter' => "");
$fields['price'] = array(
		'heading' => "Unit Price",
		'table' => 't',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => 'Master, *',
		'colwidth' => '50',
		'filter' => "");
$fields['ticket_id'] = array(
		'table' => 't',
		'heading' => 'ID',
		'primarykey' => true,
		'fieldgroup' => 'Master, *',
		'search_more' => true,
		'filter' => "");

/* Field definitions end here. */

/* Field group definitions */

$tpl['fieldgroups'] = array(
	'Master' => array('label'=>'Read-only', 'url' =>''),
	'Detail' => array('label' => 'Details',
		'url' => 'taburl.php?template=tickets_detail.tpl',
		'authgroup' => array('Admin')),

);

?>