<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 10 January, 2013
	
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /help/fieldlistdoc.php.
		
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');

/* MySQL table names */

if ($all_years) {
	$db['tb'] = 'regybphotoall y, regall r';
	$db['tbnoalias'] = 'regybphotoall';
} else {
	$db['tb'] = 'regybphoto y, reg r';
	$db['tbnoalias'] = 'regybphoto';
}

global $opts;
$opts['join_clause'] = 'r.confirmation_no=y.ybconfirmation';

/* Field definitions start here */

if ($all_years) {
	$fields['esprit_year'] = [
			'heading' => "Esprit Year",
			'table' => 'r',
			'select' => true,
			'display' => true,
			'fieldgroup' => '*, Master',
	// 		'copyValue' => '9999',	//	Uncomment to test copyValue
			'width' => '8%',
			'search_more' => false,
			'filter' => ""];
} else {
	$fields['esprit_year'] = [
			'heading' => "Esprit Year",
			'table' => 'r',
			'select' => true,
			'display' => true,
			'fieldgroup' => '*',
			'search_more' => false,
			'filter' => ""];
}

$fields['yp_timestamp'] = array(
		'heading' => "Time Stamp",
		'table' => 'y',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'fieldgroup' => '*, Master',
		'helpfile' => 'help/timestamphelp.php',
		'filter' => "");
$fields['yp_updated'] = array(
		'heading' => "Time Stamp",
		'table' => 'y',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'fieldgroup' => '*',
		'helpfile' => 'help/timestamphelp.php',
		'filter' => "");
$fields['firstnamepref'] = array(
		'heading' => "Preferred First Name",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*, Master',
		'filter' => "");
$fields['lastnamepref'] = array(
		'heading' => "Preferred Last Name",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*, Master',
		'filter' => "");
$fields['ybconfirmation'] = array(
		'heading' => "Registration No.",
		'table' => 'y',
		'display' => true,
		'fieldgroup' => 'Master, *',
		'filter' => "");
$fields['ybframe'] = array(
		'heading' => "Frame",
		'table' => 'y',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => "");
$fields['id'] = array(
'heading' => 'Entry number',
		'primarykey' => true,
		'table' => 'y',
		'search_more' => true,
		'fieldgroup' => '*',
		'filter' => "");

/* End of Field definitions end here. */

/* Field group definitions */

if ($all_years) {
	$tpl['fieldgroups'] = array(
		'Master' => array('label'=>'Master',
			'url' =>''),
		'Basic' => ['label' => 'Splash',
			'url' => 'taburl.php?template=splash.tpl&access=read_only&all_years=true',
			'authgroup' => ['Admin'],
			'width' => 2000,
			'height' => 900],
		'Account' => ['label' => 'Account',
			'icon' => '/images/icon-transactions.png',
			'url' => 'taburl.php?template=accounts_detail.tpl&access=read_only&all_years=true',
			'width' => 1800,
			'height' => '700',
			'authgroup' => ['Admin']],
		'Orders' => ['label' => 'Order Table',
			'url' => '../ybphotoorders&access=read_only&all_years=true',
			'width' => 1800,
			'height' => '700',
			'authgroup' => ['Admin']],
		'Products' => ['label' => 'Products Table',
			'url' => '../ybphotoproducts&access=read_only&all_years=true',
			'width' => 1800,
			'height' => '700',
			'authgroup' => ['Admin']]
	);
} else {
	$tpl['fieldgroups'] = array(
		'Master' => array('label'=>'Master',
			'url' =>''),
		'Basic' => ['label' => 'Splash',
			'url' => 'taburl.php?template=splash.tpl',
			'authgroup' => ['Admin'],
			'width' => 2000,
			'height' => 900],
		'Account' => ['label' => 'Account',
			'icon' => '/images/icon-transactions.png',
			'url' => 'taburl.php?template=accounts_detail.tpl',
			'width' => 1800,
			'height' => '700',
			'authgroup' => ['Admin']],
		'Delete' => ['label' => 'Delete',
			'url' => 'delete.php',
			'authgroup' => ['Admin'],
			'scroll' => 'No'	//	Prevent scrolling to this screen
		],
		'Orders' => ['label' => 'Order Table',
			'url' => '../ybphotoorders',
			'width' => 1800,
			'height' => '700',
			'authgroup' => ['Admin']],
		'Products' => ['label' => 'Products Table',
			'url' => '../ybphotoproducts',
			'width' => 1800,
			'height' => '700',
			'authgroup' => ['Admin']]
	);
}
?>