<?php
/*	This file generates a list of the yearbok photo orders for a particular
	person. The person is identified by their confirmation number. The list is
	intended for inclusion in an iframe in the accounts_detail.tpl template:
	
		<iframe src="yborders-list.php?confirmation={$mydata.confirmation_no}&submit={$mydata.timestamp}" height="150" width="500"></iframe>

*/
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");	// WAAAY in the past
header("Cache-Control: no-cache");
header("Pragma: no-cache");
print '<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">';
print '<style>
.tiny {		/*	For annotations */
	font-size: 0.75em;
}
</style>';
print '<link href="../css/styles.css" rel="stylesheet" type="text/css" media="all">';
print '<link href="../css/reports.css" rel="stylesheet" type="text/css" media="all">';

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once "mysql_utilities.php";

print "<script type=\"text/javascript\" src=\"/lib/js/jquery.js\"></script>";
require_once "yb_utils.php";



print <<<HSCODE
<!-- Highslide code -->
<script type="text/javascript" src="/lib/js/highslide/highslide-full.js"></script>
<!-- 
<script type="text/javascript" src="/lib/js/highslide/mobile.js"></script>
 -->
<script type="text/javascript" src="/lib/js/highslide/highslide-config_noslide.js"></script>
<link rel="stylesheet" type="text/css" href="/lib/js/highslide/highslide.css">
HSCODE;



mysql_login('Normal');

$db['tb'] = 'ybphotoorders';
$db['tb2'] = 'reg';

$confirmation_no = $_REQUEST['confirmation'];
$this_submit = $_REQUEST['submit'];
$authgroup = $_REQUEST['authgroup'];
// Force caching to expire ASAP or displayed payment info is out of date
//	print '<pre>';print_r($_REQUEST);print '</pre><br />';

/*	Include a mini-form for adding a new payment */
print '<form name="miniform" id="miniform_id" accept-charset="UTF-8" action="yborders_exe.php" method="POST">';

define ('QUADODO_IN_SYSTEM', true);

print '<table class="row-0">';

if (empty($confirmation_no)) {
	print '<tr><td></td><td class="warning">Missing confirmation no. Cannot locate orders.</tr>';
} else {
	print '<tr class="row-1"><td width="15%">Timestamp</td>
	<td width="15%">Item Name</td>
	<td width="20%">Item Description</td>
	<td width="25%">Order Notes</td>
	<td width="8%">Qty</td>
	<td width="8%">Each</td>
	<td>Status</td>
	<td nowrap class="right" width="8%">Amount</td></tr>';
	$balance = 0;

	$sql = "SELECT o.timestamp, o.id, o.item_no, p.name, p.unit_price unit,
		p.description description,o.quantity,
		o.notes notes, o.price, o.status
	FROM ybphotoorders o INNER JOIN ybphotoproducts p ON o.item_no=p.prod_id
	WHERE confirmation_no=$confirmation_no ORDER BY timestamp";
	
	// print 'Final SQL query: '.$sql;
	
	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to retrieve transactions for display. Sorry!');

	while ($row = mysqli_fetch_array($result)) {
		$balance += $row['price'];
		print "<tr>
		<td>{$row['timestamp']}</td>
		<td>{$row['name']}<a href=\"#\" onclick=\"return hs.htmlExpand(this, {contentId:'prod_id{$row['id']}', width: '600px', height: '300px'})\"><img src=\"/images/sm_help.png\" height=\"20\"></a>
		<div class=\"highslide-html-content\" id=\"prod_id{$row['id']}\">{$row['description']}</div></td>
		<td>{$row['description']}</td>
		<td>{$row['notes']}</td>
		<td style=\"width:10em\">{$row['quantity']}</td>
		<td style=\"width:10em\">{$row['unit']}</td>
		<td>{$row['status']}</td>
		<td class=\"right\">". sprintf("$%.2f", $row['price'])."</td>
		<td>";
		print (in_array($authgroup, array('Admin', 'Registrar')))
			? "<a href=\"yborders-delete.php?id={$row['id']}&confirmation_no=$confirmation_no&authgroup=$authgroup\" onclick=\"return confirm('Are you sure you want to delete?')\">
			<img src=\"/images/sm_delete.png\"></a>"
			: '&nbsp;';
		print '</td></tr>';
	}
}
$items = get_yb_product_items();	//	Empty parameter means get all products.
print <<<STUFF
<tr class="row-0">
<td></td>
<td><input type="hidden" name="confirmation" id="confirmation" value=$confirmation_no />
<input type="hidden" name="authgroup" value="$authgroup" />
<input type="hidden" name="submit" value=$submit />
<input type="hidden" id="yb_product_id" name="yb_product" value="NULL">


<input type="text" name="name" id="name_id"><br /><span class="tiny">Item</span></td>
<td><input type="textarea" style="width: 100%; height: 5em" name="description" id="description_id" placeholder="Descriptive note"><br /><span class="tiny">Item</span></td>
<td><input type="textarea" style="width: 100%; height: 5em" name="notes" id="notes_id" placeholder="Order details"><br /><span class="tiny">Item</span></td>
<td><input type="text" size="8" id="quantity_id" name="quantity" value="1" onchange="this.form.price_id.value=piece.unit_price*this.value"><br /><span class="tiny">Quantity</span></td>
<td><input type="text" size="8" id="unit_price_id" name="unit_price"></td>
<td></td>
<td class="right"><input type="text" id="price_id" name="price"></td>
<td><input type="image" src="/images/sm_add.png" onclick="this.form.price_id.value=this.form.amount.value;this.form.submit;"></td></tr>
STUFF;
print '<tr><td class="bold right">Assistant</td>
<td colspan="3">';
// foreach ($items as $this_item => $item) {
//  	print "<br />Item: "; print_r($item);
//  	$temp_j = json_encode($item);
//  	print "<br />$temp_j</br />";
// }
print '<select name="yb_prod_select" id="yb_prod_type" onChange="update_posting(this.value)">';
print '<option value="">Please select a product, adjust quantity and post...</option>';
foreach ($items as $this_item => $item) {
	$item['quantity'] = 1;
	$item['price'] = $item['quantity'] * $item['unit_price'];
	$j_value = urlencode(json_encode($item));
	print "<option value=\"$j_value\">{$item['name']}</option>";
}
print '</select>';
$balance = round($balance, 2);
$msg = $balance == 0 ? '<div class="transaction bold">PAID IN FULL</div>' : ($balance <0 ? '<div class="warning" style="color:#00AA00">CREDIT OWING</div>' : '<div class="warning">BALANCE OUTSTANDING</div>');
print "<tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td><td>&nbsp;</td><td>$msg</td><td nowrap class=\"bold\">".sprintf("$%.2f", $balance)."</td></tr>";


print '<script type="text/javascript">
	function urldecode(str) {
	   return decodeURIComponent((str+"").replace(/\+/g, "%20"));
	};
	function update_posting(j_piece) {
//  	alert("In update_posting....");
	piece = JSON.parse(urldecode(j_piece));
	document.getElementById("quantity_id").value=piece.quantity;
	document.getElementById("name_id").value=piece.name;
	document.getElementById("description_id").value=piece.description;
	document.getElementById("notes_id").value=piece.notes;
	document.getElementById("yb_product_id").value=piece.prod_id;
	document.getElementById("unit_price_id").value=piece.unit_price;
	document.getElementById("price_id").value=piece.quantity * piece.unit_price;
	};
</script>';
	print "<script type=\"text/javascript\">$(\"#reg_status\").html(\"$statusmsg\");
	</script>";

print '</table>';
print '</form>';
?>