<?php
/*
	Esprit Registration System
	by Stephanie Mitchell
	Assistant Registration Form
	8 May, 2015.
	Updated to remove reliance on Forms to Go, which is no longer supported.
*/

define('QUADODO_IN_SYSTEM', true);
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once ".config.php";
if (TESTING) {	// TESTING constant is set in config.php
	$today_text = (isset($_REQUEST['date']) ? $_REQUEST['date'] : 'now');
	$test_msg = 'TEST';
} else {
 	$today_text = 'now';
 	$test_msg = '';
}

$password = (isset($_REQUEST['password']) ? $_REQUEST['password'] : false);
$primary_email = $_REQUEST['email'] ?? '';
$primary_conf = $_REQUEST['conf'] ?? '';
$form_type = "Assistant";	//	MUST match one of the rate groups in config.php
							//	(Single, SO etc.)
require_once "classes.php";	//	Pull in everything
require_once "head.php";
?>
<html>
<!-- Enable Assistant fields -->
<script type="text/javascript">
jQuery(document).ready(function(){	//	Enable Assistant-specific fields which 
									//	were disabled by head.php above
	alwaysshow('.Assistant-specific', 'Assistant');
})</script>
<body>
<?php
if (!$check['assistant_registration_open']) {
	print closed($form_type, $date_text['registration_closed']);
	exit;
}
print masthead($form_type);

?>
<div class="section">
	<div class="headerbar">Instructions</div>
	<ol>
		<li>This form is only for pre-registering an assistant to a Presenter or Vendor, who must have already pre-registered. Note that Presenters and Vendors can only register ONE assistant in this way; additional assistants must be registered as regular attendees. To do that, please <a href="../index.php">return to Registration Start</a>.</li>
		<li>Each person attending Esprit MUST BE REGISTERED.</li>
		<li> <span class="reqd reqdhilite">Fields highlighted like this</span> are required.</li>
		<li><span class="i">Note that pre-registering does not obligate you to pay or attend nor are you guaranteed a space at Esprit or any hotel.</span></li>
		<li>Click Submit at the bottom. Your official Registration Letter will arrive via email shortly.</li>
		<?php
		if ($today < $date['payment_deadline']) {
			print "<li>Our mailing address is:<br />
				<br /> $esprit_treasurer_address<br />
				<br />
				</li>";
		}?>
		<li> We urge you to refer to these Help buttons<?php print helpbutton('helpbuttonhelp.php');?> for lots of useful information and guidance.</li>
	</ol>
	<p class="tiny">All information is kept strictly confidential.</p>
</div>
<form action="../process.php" method="post" enctype="multipart/form-data" name="form1" id="formID">

<?php
print esprit_names(array('Assistant-specific'));
print attendwith($form_type, $primary_email, $primary_conf, $_REQUEST['date']);
require_once "bill_contact.php";

/*
	Create the rate tables for each selected type.
*/
$rates = new ratetable;
print $rates->preamble($form_type);
print '<table width="100%">
	<tr>';
/*	Trailing false parameter below means this attendee type is not eligible for
	brunch and we shouldn't offer it. */
print '<td>' . $rates->table('reg', $form_type, 'You', false) . '</td>';
print '</tr></table>';
print $rates->postamble();

/*
	Add-ons
*/
require_once "other_purchases.php";
print other_purchases($form_type);

/*
	Gather the badge photo(s).
*/
$badge = new badgephoto;
print $badge->preamble($form_type);	//	Preamble
print '<table width="100%">
	<tr>';
print '<td>' . $badge->table('reg', $form_type, 'You') . '</td>';
print '</tr></table>';
print $badge->postamble();	//	Postamble

/*
	Gather the vax certificates.
*/
$vaxcert = new vaxcertificate;
print $vaxcert->preamble($form_type);	//	Preamble
print '<table width="100%">
	<tr>';
print '<td>' . $vaxcert->table('reg', $form_type, 'You') . '</td>';
print '</tr></table>';
print $vaxcert->postamble();	//	Postamble

/*
	The fine print section
*/

require_once "fine_print.php";

?>
<div><!-- Hidden fields required by this form, plus form submit button -->	
	<input type="hidden" name="noupload[source_form_type]" testdata="no" id="source_form_type" value="<?php print $form_type;?>" />
	<input type="hidden" name="password" id="password" value="<?php print $override;?>" />

	<input type="submit" id="postbut" name="Submit Pre-Registration" value="Submit Pre-Registration" />
</div>
</form>
</body>
</html>
