<?php
/*
	Esprit Registration System
	by Stephanie Mitchell
	Business Registration Form
	8 May, 2015.
*/

define('QUADODO_IN_SYSTEM', true);
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once ".config.php";
if (TESTING) {	// TESTING constant is set in config.php
	$today_text = (isset($_REQUEST['date']) ? $_REQUEST['date'] : 'now');
	$test_msg = 'TEST';
} else {
 	$today_text = 'now';
 	$test_msg = '';
}

$password = (isset($_REQUEST['password']) ? $_REQUEST['password'] : false);
$confirmation_no = isset($_COOKIE['espritOnlineRegConfirmation']) ? $_COOKIE['espritOnlineRegConfirmation'] : (isset($_REQUEST['confirmation_no']) ? $_REQUEST['confirmation_no'] : 'please enter your confirmation number');

$form_type = "Business";
require_once "classes.php";	//	Pull in everything
?>
<html>
<?php
	require_once "head.php";
?>
<body>
<?php
if ($check['preregistration_closed']) {
	print closed($form_type, $date_text['registration_closed']);
	exit;
}
if (!$check['vendor_preregistration_open']) {
	print notyetopen($form_type, $date_text['vendor_registration_open']);
	exit;
}
print masthead('Business');

?>
<div class="section">
	<div class="headerbar">Instructions</div>
	<ol>
		<li>This form is only for <span class="i">Esprit</span> Vendors who are pre-registering their Business. To select a different form, please <a href="../index.php">return to Registration Start</a>.</li>
		<li>Use this form to provide information specific to your business. You must already be registered as a Vendor. You'll also need your email address and the confirmation number you received when you registered.</li>
		<li>If you're registering more than one business, you can complete this form as many times as required; however, please don't submit duplicate forms for the same business.</li>
		<li><span class="reqd reqdhilite">Fields highlighted like this</span> are required.</li>
		<li>Once your registration is received and confirmed, our Vendor Coordinator will contact you to confirm any other details. Your official Registration Letter will arrive via email shortly.</li>
		<?php
		if ($today < $date['payment_deadline']) {
			print "<li>Our mailing address is:<br />
				<br /> $esprit_treasurer_address<br />
				<br />
				</li>";
		}?>
		<li> We urge you to refer to these Help buttons<?php print helpbutton('helpbuttonhelp.php');?> for lots of useful information and guidance.</li>
	</ol>
	<p class="tiny">All information is kept strictly confidential.</p>
</div>
<form action="../process.php" method="post" enctype="multipart/form-data" name="form1" id="formID">
<!-- Note time application was started -->
 <?php print '<input type="hidden" value="' . date("Y-m-d") . '" name="noupload[appstart]" testdata="no">';?>

<div class="section">
	<input type="hidden" name="testing" value="<?php print $test_msg;?>" />
	<div class="headerbar"> Verify Your Registration</div>
	<table width="100%" cellpadding="2">
		<tr>
			<td width="25%"><div class="reqd reqdhilite">Email*:<?php print helpbutton('emailhelp.php');?></div></td>
			<td width="30%"><div class="reqdhilite"><input class="validate[required],custom[email]" type="text" name="noupload[Verify_email]" id="noupload__Verify_email" size="30" value="xx" placeholder="Email address you registered with" /></div>
			</td>
		</tr>
		<tr>
			<td><div class="reqd reqdhilite">Confirmation number*:<?php print helpbutton('confnohelp.php');?></div></td>
			<td><div class="reqdhilite"><input name="noupload[preset_confirmation_no]" type="text" class="validate[required],ajax[checkVendorList]" id="Business__confirmation_no" size="30" value="<?php print $confirmation_no;?>" /></div>
			</td>
		</tr>
	</table>
</div>
<?php require_once "businessdoc.php";?>
<?php

/*
	The fine print section
*/

require_once "fine_print.php";

?>
<div><!-- Hidden fields required by this form, plus form submit button -->	
	<input type="hidden" name="noupload[source_form_type]" testdata="no" id="source_form_type" value="Business" />
	<input type="hidden" name="noupload[resourcestatus]" id="Business__resourcestatus" value="Inquiry" />
	<input type="hidden" name="noupload[Business][form_type]" id="Business__form_type" value="Business" />

	<input type="submit" id="postbut" name="Submit Pre-Registration" value="Submit Pre-Registration" />
</div>
</form>
</body>
</html>
