<?php
/*
	Present a list of checkboxes that indicate which sections of the form are to
	be generated. Each checkbox uses the checkshow() Javascript function to
	actually show or hide the divs.
*/
function form_switches(array $selected) {
	print "<!-- BEGIN section form_switches -->
	<div class=\"section\">
<div class=\"headerbar\">I'm using this form to:</div>
<p class=\"i\">Check all that apply.</p>";
	foreach ($selected as $sel_key => $this_sel) {
		switch ($this_sel) {

		case 'Single':
		case 'Resource_Presenter':
		case 'Resource_Vendor':
		case 'Committee_Full':
		case 'Committee_Partial':
			print "<input type=\"checkbox\" value=\"Yes\" testdata=\"no\" checked disabled>Register myself<br />";
			break;

		case 'SO':
			print "<input type=\"checkbox\" value=\"Yes\" name=\"noupload[soattending]\" testdata=\"no\" id=\"soattending\" onLoad=\"checkshow('soattending','.so', 'SO')\" onChange=\"checkshow('soattending','.so', 'SO')\">Register my Significant Other<br />";
			break;

		case 'Couple':
			print "<input type=\"checkbox\" value=\"Yes\" testdata=\"no\" checked disabled>Register myself<br />";
			break;

		case 'Couple2':
			print "<input type=\"checkbox\" value=\"Yes\" name=\"noupload[soattending]\" testdata=\"no\" id=\"soattending\" onLoad=\"checkshow('soattending','.c2', 'Couple2')\" onChange=\"checkshow('soattending','.c2', 'Couple2')\">Register my Significant Other<br />";
			break;

		case 'SO-specific':
			print "<input type=\"checkbox\" value=\"Yes\" name=\"noupload[soattending]\" testdata=\"no\" id=\"soattending\" onLoad=\"checkshow('soattending','.af', 'SO')\" onChange=\"checkshow('soattending','.so', 'SO')\" checked disabled>Register me as an SO attending with an already-registered attendee<br />";
			break;

		case 'Add_Family':
			print "<input type=\"checkbox\" value=\"Yes\" name=\"noupload[afattending]\" testdata=\"no\" id=\"afattending\" onLoad=\"checkshow('afattending','.af', 'Add_Family')\" onChange=\"checkshow('afattending','.af', 'Add_Family')\">Register another family member attending with me<br />";
			break;

		case 'Add_Family-specific':
			print "<input type=\"checkbox\" value=\"Yes\" name=\"noupload[afattending]\" testdata=\"no\" id=\"afattending\" onLoad=\"checkshow('afattending','.af', 'Add_Family')\" onChange=\"checkshow('afattending','.af', 'Add_Family')\" checked disabled>Register me as a family member attending with an already-registered attendee<br />";
			break;

		case 'Assistant':
			print "<input type=\"checkbox\" value=\"Yes\" name=\"noupload[asattending]\" testdata=\"no\" id=\"asattending\" onLoad=\"checkshow('asattending','.as', 'Assistant')\" onChange=\"checkshow('asattending','.as', 'Assistant')\">Register my Assistant<br />";
			break;

		case 'Assistant-specific':
			print "<input type=\"checkbox\" value=\"Yes\" name=\"noupload[asattending]\" testdata=\"no\" id=\"asattending\" onLoad=\"checkshow('asattending','.as', 'Assistant')\" onChange=\"checkshow('asattending','.AS')\" checked disabled>Register me as an Assistant<br />";
			break;

		case 'Guest-specific':
			print "<input type=\"checkbox\" value=\"Yes\" name=\"noupload[guattending]\" testdata=\"no\" id=\"guattending\" onLoad=\"checkshow('guattending','.gu', 'Guest')\" onChange=\"checkshow('guattending','.gu', 'Guest')\" checked disabled>Register a Guest<br />";
			break;

		case 'Observer-specific':
			print "<input type=\"checkbox\" value=\"Yes\" name=\"noupload[obattending]\" testdata=\"no\" id=\"obattending\" onLoad=\"checkshow('obattending','.ob', 'Observer')\" onChange=\"checkshow('obattending','.ob', 'Observer')\" checked disabled>Register an Observer<br />";
			break;

		case 'Volunteer-specific':
			print "<input type=\"checkbox\" value=\"Yes\" name=\"noupload[voattending]\" testdata=\"no\" id=\"voattending\" onLoad=\"checkshow('voattending','.vo', 'Volunteer')\" onChange=\"checkshow('voattending','.vo', 'Volunteer')\" checked disabled>Register a Volunteer<br />";
			break;

		case 'Presentation':
			print "<input type=\"checkbox\" value=\"Yes\" name=\"noupload[regpresent]\" testdata=\"no\" id=\"regpresent_b\" onLoad=\"checkshow('regpresent','.pres', 'regpresent')\" onChange=\"checkshow('regpresent','.pres', 'regpresent')\">Register my presentation<br />";
			break;

		case 'Business':
			print "<input type=\"checkbox\" value=\"Yes\" name=\"noupload[regbusiness]\" testdata=\"no\" id=\"regbusiness\" onLoad=\"checkshow('regbusiness','.bus', 'regbusiness')\" onChange=\"checkshow('regbusiness','.bus', 'regbusiness')\">Register my business<br />";
			break;

		default:
			print "<span class=\"errormsg\"> Invalid DIV type \"$this_sel\" passed to form_switches()</span><br />";

		}

	}
	print "</div>";
	print "<!-- END section form_switches -->";
}
?>
